/*
 * Decompiled with CFR 0.152.
 */
package net.kyori.adventure.platform.fabric.impl.mixin.minecraft.server.level;

import com.google.common.collect.MapMaker;
import io.netty.channel.Channel;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.audience.ForwardingAudience;
import net.kyori.adventure.identity.Identity;
import net.kyori.adventure.platform.fabric.FabricServerAudiences;
import net.kyori.adventure.platform.fabric.PlayerLocales;
import net.kyori.adventure.platform.fabric.impl.LocaleHolderBridge;
import net.kyori.adventure.platform.fabric.impl.accessor.minecraft.network.ConnectionAccess;
import net.kyori.adventure.platform.fabric.impl.accessor.minecraft.network.ServerGamePacketListenerImplAccess;
import net.kyori.adventure.platform.fabric.impl.mixin.minecraft.world.entity.player.PlayerMixin;
import net.kyori.adventure.platform.fabric.impl.server.FabricServerAudiencesImpl;
import net.kyori.adventure.platform.fabric.impl.server.FriendlyByteBufBridge;
import net.kyori.adventure.platform.fabric.impl.server.RenderableAudience;
import net.kyori.adventure.platform.fabric.impl.server.ServerPlayerAudience;
import net.kyori.adventure.platform.fabric.impl.server.ServerPlayerBridge;
import net.kyori.adventure.pointer.Pointers;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1937;
import net.minecraft.class_2165;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_2772;
import net.minecraft.class_2803;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3244;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_3222.class})
public abstract class ServerPlayerMixin
extends PlayerMixin
implements ForwardingAudience.Single,
LocaleHolderBridge,
RenderableAudience,
ServerPlayerBridge {
    @Shadow
    @Final
    public MinecraftServer field_13995;
    @Shadow
    public class_3244 field_13987;
    private Audience adventure$backing;
    private Locale adventure$locale;
    private final Map<FabricServerAudiencesImpl, Audience> adventure$renderers = new MapMaker().weakKeys().makeMap();
    private class_2561 adventure$tabListHeader = class_2561.method_43473();
    private class_2561 adventure$tabListFooter = class_2561.method_43473();
    private Set<class_2960> adventure$arguments = Set.of();

    protected ServerPlayerMixin(class_1299<? extends class_1309> entityType, class_1937 level) {
        super(entityType, level);
    }

    @Inject(method={"<init>"}, at={@At(value="TAIL")})
    private void adventure$init(CallbackInfo ci) {
        this.adventure$backing = FabricServerAudiences.of(this.field_13995).audience((class_2165)this);
    }

    @NotNull
    public Audience audience() {
        return this.adventure$backing;
    }

    @Override
    public Audience renderUsing(FabricServerAudiencesImpl controller) {
        return this.adventure$renderers.computeIfAbsent(controller, ctrl -> new ServerPlayerAudience((class_3222)this, (FabricServerAudiencesImpl)ctrl));
    }

    @Override
    @NotNull
    public Locale adventure$locale() {
        return this.adventure$locale;
    }

    @Override
    protected void adventure$populateExtraPointers(Pointers.Builder builder) {
        builder.withDynamic(Identity.LOCALE, this::adventure$locale);
    }

    @Override
    public void bridge$updateTabList(@Nullable class_2561 header, @Nullable class_2561 footer) {
        if (header != null) {
            this.adventure$tabListHeader = header;
        }
        if (footer != null) {
            this.adventure$tabListFooter = footer;
        }
        class_2772 packet = new class_2772(this.adventure$tabListHeader, this.adventure$tabListFooter);
        this.field_13987.method_14364((class_2596)packet);
    }

    @Inject(method={"updateOptions"}, at={@At(value="HEAD")})
    private void adventure$handleLocaleUpdate(class_2803 information, CallbackInfo ci) {
        String language = information.comp_266();
        @Nullable Locale locale = LocaleHolderBridge.toLocale(language);
        if (!Objects.equals(this.adventure$locale, locale)) {
            this.adventure$locale = locale;
            ((PlayerLocales.Changed)PlayerLocales.CHANGED_EVENT.invoker()).onLocaleChanged((class_3222)this, locale);
        }
    }

    @Inject(method={"restoreFrom"}, at={@At(value="RETURN")})
    private void copyData(class_3222 old, boolean alive, CallbackInfo ci) {
        FabricServerAudiencesImpl.forEachInstance(controller -> controller.bossBars().replacePlayer(old, (class_3222)this));
        Channel channel = ((ConnectionAccess)((ServerGamePacketListenerImplAccess)this.field_13987).accessor$connection()).accessor$channel();
        if (channel != null) {
            channel.attr(FriendlyByteBufBridge.CHANNEL_RENDER_DATA).set((Object)this);
        }
    }

    @Inject(method={"disconnect"}, at={@At(value="RETURN")})
    private void adventure$removeBossBarsOnDisconnect(CallbackInfo ci) {
        FabricServerAudiencesImpl.forEachInstance(controller -> controller.bossBars().unsubscribeFromAll((class_3222)this));
    }

    @Override
    public Set<class_2960> bridge$knownArguments() {
        return this.adventure$arguments;
    }

    @Override
    public void bridge$knownArguments(Set<class_2960> arguments) {
        this.adventure$arguments = Set.copyOf(arguments);
    }

    @Inject(method={"restoreFrom"}, at={@At(value="RETURN")})
    public void adventure$copyData(class_3222 from, boolean keepEverything, CallbackInfo ci) {
        this.bridge$knownArguments(((ServerPlayerBridge)from).bridge$knownArguments());
    }
}

