/*
 * Decompiled with CFR 0.152.
 */
package net.kyori.adventure.platform.fabric.impl.server;

import com.google.common.collect.Iterables;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.WeakHashMap;
import java.util.function.Consumer;
import java.util.function.Function;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.platform.fabric.AdventureCommandSourceStack;
import net.kyori.adventure.platform.fabric.FabricAudiences;
import net.kyori.adventure.platform.fabric.FabricServerAudiences;
import net.kyori.adventure.platform.fabric.impl.AdventureCommandSourceStackInternal;
import net.kyori.adventure.platform.fabric.impl.AdventureCommon;
import net.kyori.adventure.platform.fabric.impl.FabricAudiencesInternal;
import net.kyori.adventure.platform.fabric.impl.server.CommandSourceAudience;
import net.kyori.adventure.platform.fabric.impl.server.RenderableAudience;
import net.kyori.adventure.platform.fabric.impl.server.ServerBossBarListener;
import net.kyori.adventure.pointer.Pointered;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.flattener.ComponentFlattener;
import net.kyori.adventure.text.renderer.ComponentRenderer;
import net.kyori.adventure.translation.GlobalTranslator;
import net.minecraft.class_2165;
import net.minecraft.class_2168;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import net.minecraft.class_7924;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class FabricServerAudiencesImpl
implements FabricServerAudiences,
FabricAudiencesInternal {
    private static final Set<FabricServerAudiencesImpl> INSTANCES = Collections.newSetFromMap(new WeakHashMap());
    private final MinecraftServer server;
    private final Function<Pointered, ?> partition;
    private final ComponentRenderer<Pointered> renderer;
    final ServerBossBarListener bossBars;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void forEachInstance(Consumer<FabricServerAudiencesImpl> actor) {
        Set<FabricServerAudiencesImpl> set = INSTANCES;
        synchronized (set) {
            for (FabricServerAudiencesImpl instance : INSTANCES) {
                actor.accept(instance);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FabricServerAudiencesImpl(MinecraftServer server, Function<Pointered, ?> partition, ComponentRenderer<Pointered> renderer) {
        this.server = server;
        this.partition = partition;
        this.renderer = renderer;
        this.bossBars = new ServerBossBarListener(this);
        Set<FabricServerAudiencesImpl> set = INSTANCES;
        synchronized (set) {
            INSTANCES.add(this);
        }
    }

    @NotNull
    public Audience all() {
        return Audience.audience((Audience[])new Audience[]{this.console(), this.players()});
    }

    @NotNull
    public Audience console() {
        return this.audience((class_2165)this.server);
    }

    @NotNull
    public Audience players() {
        return Audience.audience(this.audiences(this.server.method_3760().method_14571()));
    }

    @NotNull
    public Audience player(@NotNull UUID playerId) {
        @Nullable class_3222 player = this.server.method_3760().method_14602(playerId);
        return player != null ? this.audience((class_2165)player) : Audience.empty();
    }

    private Iterable<Audience> audiences(Iterable<? extends class_3222> players) {
        return Iterables.transform(players, this::audience);
    }

    @NotNull
    public Audience permission(@NotNull String permission) {
        return Audience.empty();
    }

    @Override
    @NotNull
    public AdventureCommandSourceStack audience(@NotNull class_2168 source) {
        if (!(source instanceof AdventureCommandSourceStackInternal)) {
            throw new IllegalArgumentException("The AdventureCommandSource mixin failed!");
        }
        AdventureCommandSourceStackInternal internal = (AdventureCommandSourceStackInternal)source;
        return internal.adventure$audience(this.audience(internal.adventure$source()), this);
    }

    @Override
    @NotNull
    public Audience audience(@NotNull class_2165 source) {
        if (source instanceof RenderableAudience) {
            RenderableAudience renderable = (RenderableAudience)source;
            return renderable.renderUsing(this);
        }
        if (source instanceof Audience) {
            Audience audience = (Audience)source;
            return audience;
        }
        return new CommandSourceAudience(source, this);
    }

    @Override
    @NotNull
    public Audience audience(@NotNull Iterable<class_3222> players) {
        return Audience.audience(this.audiences(players));
    }

    @NotNull
    public Audience world(@NotNull Key worldId) {
        @Nullable class_3218 level = this.server.method_3847(class_5321.method_29179((class_5321)class_7924.field_41223, (class_2960)FabricAudiences.toNative(Objects.requireNonNull(worldId, "worldId"))));
        if (level != null) {
            return this.audience(level.method_18456());
        }
        return Audience.empty();
    }

    @NotNull
    public Audience server(@NotNull String serverName) {
        return Audience.empty();
    }

    @Override
    @NotNull
    public ComponentFlattener flattener() {
        return AdventureCommon.FLATTENER;
    }

    @Override
    @NotNull
    public ComponentRenderer<Pointered> renderer() {
        return this.renderer;
    }

    @Override
    public @NotNull class_2561 toNative(@NotNull Component adventure) {
        if (adventure == Component.empty()) {
            return class_2561.method_43473();
        }
        return AdventureCommon.SIDE_PROXY.createWrappedComponent(Objects.requireNonNull(adventure, "adventure"), this.partition, this.renderer);
    }

    public ServerBossBarListener bossBars() {
        return this.bossBars;
    }

    public void close() {
    }

    @Override
    @NotNull
    public class_5455 registryAccess() {
        return this.server.method_30611();
    }

    public static final class Builder
    implements FabricServerAudiences.Builder {
        private final MinecraftServer server;
        private Function<Pointered, ?> partition;
        private ComponentRenderer<Pointered> renderer;

        public Builder(MinecraftServer server) {
            this.server = server;
            this.componentRenderer(AdventureCommon.localePartition(), (ComponentRenderer)GlobalTranslator.renderer());
        }

        public @NotNull FabricServerAudiences.Builder componentRenderer(@NotNull ComponentRenderer<Pointered> componentRenderer) {
            this.renderer = Objects.requireNonNull(componentRenderer, "componentRenderer");
            return this;
        }

        public @NotNull FabricServerAudiences.Builder partition(@NotNull Function<Pointered, ?> partitionFunction) {
            this.partition = Objects.requireNonNull(partitionFunction, "partitionFunction");
            return this;
        }

        @NotNull
        public FabricServerAudiencesImpl build() {
            return new FabricServerAudiencesImpl(this.server, this.partition, this.renderer);
        }
    }
}

