/*
 * Decompiled with CFR 0.152.
 */
package net.kyori.adventure.platform.fabric.impl.server;

import java.time.Duration;
import java.util.Objects;
import java.util.Optional;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.audience.MessageType;
import net.kyori.adventure.bossbar.BossBar;
import net.kyori.adventure.chat.ChatType;
import net.kyori.adventure.chat.SignedMessage;
import net.kyori.adventure.identity.Identity;
import net.kyori.adventure.inventory.Book;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.platform.fabric.FabricAudiences;
import net.kyori.adventure.platform.fabric.impl.AdventureCommon;
import net.kyori.adventure.platform.fabric.impl.GameEnums;
import net.kyori.adventure.platform.fabric.impl.PointerProviderBridge;
import net.kyori.adventure.platform.fabric.impl.accessor.minecraft.network.ServerGamePacketListenerImplAccess;
import net.kyori.adventure.platform.fabric.impl.accessor.minecraft.world.level.LevelAccess;
import net.kyori.adventure.platform.fabric.impl.server.FabricServerAudiencesImpl;
import net.kyori.adventure.platform.fabric.impl.server.ServerPlayerBridge;
import net.kyori.adventure.pointer.Pointers;
import net.kyori.adventure.sound.Sound;
import net.kyori.adventure.sound.SoundStop;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.gson.GsonComponentSerializer;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import net.kyori.adventure.title.Title;
import net.kyori.adventure.title.TitlePart;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2378;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2556;
import net.minecraft.class_2596;
import net.minecraft.class_2653;
import net.minecraft.class_2765;
import net.minecraft.class_2767;
import net.minecraft.class_2770;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_5321;
import net.minecraft.class_5888;
import net.minecraft.class_5903;
import net.minecraft.class_5904;
import net.minecraft.class_5905;
import net.minecraft.class_6880;
import net.minecraft.class_7469;
import net.minecraft.class_7471;
import net.minecraft.class_7604;
import net.minecraft.class_7617;
import net.minecraft.class_7924;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ServerPlayerAudience
implements Audience {
    private final class_3222 player;
    private final FabricServerAudiencesImpl controller;

    public ServerPlayerAudience(class_3222 player, FabricServerAudiencesImpl controller) {
        this.player = player;
        this.controller = controller;
    }

    void sendPacket(class_2596<?> packet) {
        this.player.field_13987.method_14364(packet);
    }

    public void sendMessage(@NotNull Component message) {
        this.player.method_43496(this.controller.toNative(message));
    }

    @Deprecated
    public void sendMessage(Identity source, Component text, MessageType type) {
        boolean shouldSend;
        switch (this.player.method_14238()) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case field_7538: {
                boolean bl = true;
                break;
            }
            case field_7539: {
                boolean bl;
                if (type == MessageType.SYSTEM) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            case field_7536: {
                boolean bl = shouldSend = false;
            }
        }
        if (shouldSend) {
            this.player.method_43496(this.controller.toNative(text));
        }
    }

    private class_2556.class_7602 toMc(ChatType.Bound adv) {
        return AdventureCommon.chatTypeToNative(adv, this.controller);
    }

    public void sendMessage(@NotNull Component message, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull ChatType.Bound boundChatType) {
        class_7604.class_7606 outgoing = new class_7604.class_7606(this.controller.toNative(message));
        this.player.method_43505((class_7604)outgoing, false, this.toMc(boundChatType));
    }

    public void sendMessage(@NotNull SignedMessage signedMessage, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull ChatType.Bound boundChatType) {
        SignedMessage signedMessage2 = signedMessage;
        if (signedMessage2 instanceof class_7471) {
            class_7471 pcm = (class_7471)signedMessage2;
            if (pcm.method_46293()) {
                this.player.method_43505((class_7604)new class_7604.class_7606(pcm.method_46291()), false, this.toMc(boundChatType));
            } else {
                this.player.method_43505((class_7604)new class_7604.class_7607(pcm), false, this.toMc(boundChatType));
            }
        } else {
            this.sendMessage((Component)Objects.requireNonNullElse(signedMessage.unsignedContent(), Component.text((String)signedMessage.message())), boundChatType);
        }
    }

    public void deleteMessage(// Could not load outer class - annotation placement on inner may be incorrect
    @NotNull SignedMessage.Signature signature) {
        this.sendPacket((class_2596<?>)new class_7617(((class_7469)signature).method_46277(((ServerGamePacketListenerImplAccess)this.player.field_13987).accessor$messageSignatureCache())));
    }

    public void sendActionBar(@NotNull Component message) {
        this.player.method_43502(this.controller.toNative(message), true);
    }

    public void showBossBar(@NotNull BossBar bar) {
        FabricServerAudiencesImpl.forEachInstance(controller -> {
            if (controller != this.controller) {
                controller.bossBars.unsubscribe(this.player, bar);
            }
        });
        this.controller.bossBars.subscribe(this.player, bar);
    }

    public void hideBossBar(@NotNull BossBar bar) {
        FabricServerAudiencesImpl.forEachInstance(controller -> controller.bossBars.unsubscribe(this.player, bar));
    }

    private long seed(@NotNull Sound sound) {
        if (sound.seed().isPresent()) {
            return sound.seed().getAsLong();
        }
        return ((LevelAccess)this.player.method_14220()).accessor$threadSafeRandom().method_43055();
    }

    private class_6880<class_3414> eventHolder(@NotNull Sound sound) {
        class_2960 soundKey;
        class_2378 soundEventRegistry = this.controller.registryAccess().method_30530(class_7924.field_41225);
        Optional eventOptional = soundEventRegistry.method_40264(class_5321.method_29179((class_5321)class_7924.field_41225, (class_2960)(soundKey = FabricAudiences.toNative(sound.name()))));
        return eventOptional.isPresent() ? (class_6880)eventOptional.get() : class_6880.method_40223((Object)class_3414.method_47908((class_2960)soundKey));
    }

    public void playSound(@NotNull Sound sound) {
        this.playSound(sound, this.player.method_23317(), this.player.method_23318(), this.player.method_23321());
    }

    public void playSound(@NotNull Sound sound, double x, double y, double z) {
        this.sendPacket((class_2596<?>)new class_2767(this.eventHolder(sound), GameEnums.SOUND_SOURCE.toMinecraft(sound.source()), x, y, z, sound.volume(), sound.pitch(), this.seed(sound)));
    }

    public void playSound(@NotNull Sound sound, // Could not load outer class - annotation placement on inner may be incorrect
    @NotNull Sound.Emitter emitter) {
        class_3222 targetEntity;
        if (emitter == Sound.Emitter.self()) {
            targetEntity = this.player;
        } else if (emitter instanceof class_1297) {
            targetEntity = (class_1297)emitter;
        } else {
            throw new IllegalArgumentException("Provided emitter '" + emitter + "' was not Sound.Emitter.self() or an Entity");
        }
        if (!this.player.field_6002.equals(targetEntity.field_6002)) {
            return;
        }
        this.sendPacket((class_2596<?>)new class_2765(this.eventHolder(sound), GameEnums.SOUND_SOURCE.toMinecraft(sound.source()), (class_1297)targetEntity, sound.volume(), sound.pitch(), this.seed(sound)));
    }

    public void stopSound(@NotNull SoundStop stop) {
        @Nullable Key sound = stop.sound();
        // Could not load outer class - annotation placement on inner may be incorrect
        @Nullable Sound.Source src = stop.source();
        @Nullable class_3419 cat = src == null ? null : GameEnums.SOUND_SOURCE.toMinecraft(src);
        this.sendPacket((class_2596<?>)new class_2770(sound == null ? null : FabricAudiences.toNative(sound), cat));
    }

    public void openBook(@NotNull Book book) {
        class_1799 bookStack = new class_1799((class_1935)class_1802.field_8360, 1);
        class_2487 bookTag = bookStack.method_7948();
        bookTag.method_10582("title", ServerPlayerAudience.validateField(this.adventure$plain(book.title()), 32, "title"));
        bookTag.method_10582("author", this.adventure$plain(book.author()));
        class_2499 pages = new class_2499();
        if (book.pages().size() > 100) {
            throw new IllegalArgumentException("Book provided had " + book.pages().size() + " pages, but is only allowed a maximum of 100");
        }
        for (Component page : book.pages()) {
            pages.add((Object)class_2519.method_23256((String)ServerPlayerAudience.validateField(this.adventure$serialize(page), Short.MAX_VALUE, "page")));
        }
        bookTag.method_10566("pages", (class_2520)pages);
        bookTag.method_10556("resolved", true);
        class_1799 previous = this.player.method_31548().method_7391();
        this.sendPacket((class_2596<?>)new class_2653(-2, this.player.field_7512.method_37421(), this.player.method_31548().field_7545, bookStack));
        this.player.method_7315(bookStack, class_1268.field_5808);
        this.sendPacket((class_2596<?>)new class_2653(-2, this.player.field_7512.method_37421(), this.player.method_31548().field_7545, previous));
    }

    private static String validateField(String content, int length, String name) {
        if (content == null) {
            return content;
        }
        int actual = content.length();
        if (actual > length) {
            throw new IllegalArgumentException("Field '" + name + "' has a maximum length of " + length + " but was passed '" + content + "', which was " + actual + " characters long.");
        }
        return content;
    }

    private String adventure$plain(@NotNull Component component) {
        return PlainTextComponentSerializer.plainText().serialize(this.controller.renderer().render(component, (Object)this));
    }

    private String adventure$serialize(@NotNull Component component) {
        return (String)GsonComponentSerializer.gson().serialize(this.controller.renderer().render(component, (Object)this));
    }

    public void showTitle(@NotNull Title title) {
        Title.Times times;
        if (title.subtitle() != Component.empty()) {
            this.sendPacket((class_2596<?>)new class_5903(this.controller.toNative(title.subtitle())));
        }
        if ((times = title.times()) != null) {
            int fadeIn = ServerPlayerAudience.ticks(times.fadeIn());
            int fadeOut = ServerPlayerAudience.ticks(times.fadeOut());
            int dwell = ServerPlayerAudience.ticks(times.stay());
            if (fadeIn != -1 || fadeOut != -1 || dwell != -1) {
                this.sendPacket((class_2596<?>)new class_5905(fadeIn, dwell, fadeOut));
            }
        }
        if (title.title() != Component.empty()) {
            this.sendPacket((class_2596<?>)new class_5904(this.controller.toNative(title.title())));
        }
    }

    public <T> void sendTitlePart(@NotNull TitlePart<T> part, @NotNull T value) {
        Objects.requireNonNull(value, "value");
        if (part == TitlePart.TITLE) {
            this.sendPacket((class_2596<?>)new class_5904(this.controller.toNative((Component)value)));
        } else if (part == TitlePart.SUBTITLE) {
            this.sendPacket((class_2596<?>)new class_5903(this.controller.toNative((Component)value)));
        } else if (part == TitlePart.TIMES) {
            Title.Times times = (Title.Times)value;
            int fadeIn = ServerPlayerAudience.ticks(times.fadeIn());
            int fadeOut = ServerPlayerAudience.ticks(times.fadeOut());
            int dwell = ServerPlayerAudience.ticks(times.stay());
            if (fadeIn != -1 || fadeOut != -1 || dwell != -1) {
                this.sendPacket((class_2596<?>)new class_5905(fadeIn, dwell, fadeOut));
            }
        } else {
            throw new IllegalArgumentException("Unknown TitlePart '" + part + "'");
        }
    }

    static int ticks(@NotNull Duration duration) {
        return duration.getSeconds() == -1L ? -1 : (int)(duration.toMillis() / 50L);
    }

    public void clearTitle() {
        this.sendPacket((class_2596<?>)new class_5888(false));
    }

    public void resetTitle() {
        this.sendPacket((class_2596<?>)new class_5888(true));
    }

    public void sendPlayerListHeader(@NotNull Component header) {
        Objects.requireNonNull(header, "header");
        ((ServerPlayerBridge)this.player).bridge$updateTabList(this.controller.toNative(header), null);
    }

    public void sendPlayerListFooter(@NotNull Component footer) {
        Objects.requireNonNull(footer, "footer");
        ((ServerPlayerBridge)this.player).bridge$updateTabList(null, this.controller.toNative(footer));
    }

    public void sendPlayerListHeaderAndFooter(@NotNull Component header, @NotNull Component footer) {
        ((ServerPlayerBridge)this.player).bridge$updateTabList(this.controller.toNative(Objects.requireNonNull(header, "header")), this.controller.toNative(Objects.requireNonNull(footer, "footer")));
    }

    @NotNull
    public Pointers pointers() {
        return ((PointerProviderBridge)this.player).adventure$pointers();
    }
}

