/*
 * Decompiled with CFR 0.152.
 */
package net.kyori.adventure.text.serializer.json;

import net.kyori.option.Option;
import net.kyori.option.OptionSchema;
import net.kyori.option.OptionState;
import org.jetbrains.annotations.NotNull;

public final class JSONOptions {
    private static final int VERSION_INITIAL = 0;
    private static final int VERSION_1_16 = 2526;
    private static final int VERSION_1_20_3 = 3679;
    private static final int VERSION_1_20_5 = 3819;
    private static final int VERSION_1_21_4 = 4174;
    private static final OptionSchema.Mutable UNSAFE_SCHEMA = OptionSchema.globalSchema();
    public static final Option<Boolean> EMIT_RGB = UNSAFE_SCHEMA.booleanOption(JSONOptions.key("emit/rgb"), true);
    public static final Option<HoverEventValueMode> EMIT_HOVER_EVENT_TYPE = UNSAFE_SCHEMA.enumOption(JSONOptions.key("emit/hover_value_mode"), HoverEventValueMode.class, (Enum)HoverEventValueMode.MODERN_ONLY);
    public static final Option<Boolean> EMIT_COMPACT_TEXT_COMPONENT = UNSAFE_SCHEMA.booleanOption(JSONOptions.key("emit/compact_text_component"), true);
    public static final Option<Boolean> EMIT_HOVER_SHOW_ENTITY_ID_AS_INT_ARRAY = UNSAFE_SCHEMA.booleanOption(JSONOptions.key("emit/hover_show_entity_id_as_int_array"), true);
    public static final Option<Boolean> VALIDATE_STRICT_EVENTS = UNSAFE_SCHEMA.booleanOption(JSONOptions.key("validate/strict_events"), true);
    public static final Option<Boolean> EMIT_DEFAULT_ITEM_HOVER_QUANTITY = UNSAFE_SCHEMA.booleanOption(JSONOptions.key("emit/default_item_hover_quantity"), true);
    public static final Option<ShowItemHoverDataMode> SHOW_ITEM_HOVER_DATA_MODE = UNSAFE_SCHEMA.enumOption(JSONOptions.key("emit/show_item_hover_data"), ShowItemHoverDataMode.class, (Enum)ShowItemHoverDataMode.EMIT_EITHER);
    public static final Option<ShadowColorEmitMode> SHADOW_COLOR_MODE = UNSAFE_SCHEMA.enumOption(JSONOptions.key("emit/shadow_color"), ShadowColorEmitMode.class, (Enum)ShadowColorEmitMode.EMIT_INTEGER);
    private static final OptionSchema SCHEMA = OptionSchema.childSchema((OptionSchema)UNSAFE_SCHEMA).frozenView();
    private static final OptionState.Versioned BY_DATA_VERSION = SCHEMA.versionedStateBuilder().version(0, b -> b.value(EMIT_HOVER_EVENT_TYPE, (Object)HoverEventValueMode.LEGACY_ONLY).value(EMIT_RGB, (Object)false).value(EMIT_HOVER_SHOW_ENTITY_ID_AS_INT_ARRAY, (Object)false).value(VALIDATE_STRICT_EVENTS, (Object)false).value(EMIT_DEFAULT_ITEM_HOVER_QUANTITY, (Object)false).value(SHOW_ITEM_HOVER_DATA_MODE, (Object)ShowItemHoverDataMode.EMIT_LEGACY_NBT).value(SHADOW_COLOR_MODE, (Object)ShadowColorEmitMode.NONE)).version(2526, b -> b.value(EMIT_HOVER_EVENT_TYPE, (Object)HoverEventValueMode.MODERN_ONLY).value(EMIT_RGB, (Object)true)).version(3679, b -> b.value(EMIT_COMPACT_TEXT_COMPONENT, (Object)true).value(EMIT_HOVER_SHOW_ENTITY_ID_AS_INT_ARRAY, (Object)true).value(VALIDATE_STRICT_EVENTS, (Object)true)).version(3819, b -> b.value(EMIT_DEFAULT_ITEM_HOVER_QUANTITY, (Object)true).value(SHOW_ITEM_HOVER_DATA_MODE, (Object)ShowItemHoverDataMode.EMIT_DATA_COMPONENTS)).version(4174, b -> b.value(SHADOW_COLOR_MODE, (Object)ShadowColorEmitMode.EMIT_INTEGER)).build();
    private static final OptionState MOST_COMPATIBLE = SCHEMA.stateBuilder().value(EMIT_HOVER_EVENT_TYPE, (Object)HoverEventValueMode.BOTH).value(EMIT_HOVER_SHOW_ENTITY_ID_AS_INT_ARRAY, (Object)false).value(EMIT_COMPACT_TEXT_COMPONENT, (Object)false).value(VALIDATE_STRICT_EVENTS, (Object)false).value(SHOW_ITEM_HOVER_DATA_MODE, (Object)ShowItemHoverDataMode.EMIT_EITHER).value(SHADOW_COLOR_MODE, (Object)ShadowColorEmitMode.EMIT_INTEGER).build();

    private JSONOptions() {
    }

    private static String key(String value) {
        return "adventure:json/" + value;
    }

    @NotNull
    public static OptionSchema schema() {
        return SCHEMA;
    }

    public static // Could not load outer class - annotation placement on inner may be incorrect
    @NotNull OptionState.Versioned byDataVersion() {
        return BY_DATA_VERSION;
    }

    @NotNull
    public static OptionState compatibility() {
        return MOST_COMPATIBLE;
    }

    public static enum ShadowColorEmitMode {
        NONE,
        EMIT_INTEGER,
        EMIT_ARRAY;

    }

    public static enum ShowItemHoverDataMode {
        EMIT_LEGACY_NBT,
        EMIT_DATA_COMPONENTS,
        EMIT_EITHER;

    }

    public static enum HoverEventValueMode {
        MODERN_ONLY,
        LEGACY_ONLY,
        BOTH;

    }
}

