/*
 * Decompiled with CFR 0.152.
 */
package net.kyori.adventure.text.serializer.plain;

import java.util.Objects;
import java.util.function.Function;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.KeybindComponent;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.TranslatableComponent;
import net.kyori.adventure.text.flattener.ComponentFlattener;
import net.kyori.adventure.text.serializer.ComponentSerializer;
import net.kyori.adventure.text.serializer.plain.PlainComponentSerializerImpl;
import net.kyori.adventure.util.Buildable;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class PlainComponentSerializer
implements ComponentSerializer<Component, TextComponent, String>,
Buildable<PlainComponentSerializer, Builder> {
    private static final PlainComponentSerializer INSTANCE = (PlainComponentSerializer)PlainComponentSerializer.builder().build();
    private final ComponentFlattener flattener;

    public static @NonNull PlainComponentSerializer plain() {
        return INSTANCE;
    }

    public static @NonNull Builder builder() {
        return new PlainComponentSerializerImpl.BuilderImpl();
    }

    @Deprecated
    public PlainComponentSerializer() {
        this(ComponentFlattener.basic());
    }

    @Deprecated
    public PlainComponentSerializer(@Nullable Function<KeybindComponent, String> keybind, @Nullable Function<TranslatableComponent, String> translatable) {
        ComponentFlattener.Builder builder = (ComponentFlattener.Builder)ComponentFlattener.basic().toBuilder();
        if (keybind != null) {
            builder.mapper(KeybindComponent.class, keybind);
        }
        if (translatable != null) {
            builder.mapper(TranslatableComponent.class, translatable);
        }
        this.flattener = (ComponentFlattener)builder.build();
    }

    PlainComponentSerializer(@NonNull ComponentFlattener flattener) {
        this.flattener = flattener;
    }

    public @NonNull TextComponent deserialize(@NonNull String input) {
        return Component.text((String)input);
    }

    public @NonNull String serialize(@NonNull Component component) {
        StringBuilder sb = new StringBuilder();
        this.serialize(sb, component);
        return sb.toString();
    }

    public void serialize(@NonNull StringBuilder sb, @NonNull Component component) {
        this.flattener.flatten(Objects.requireNonNull(component, "component"), sb::append);
    }

    public @NonNull Builder toBuilder() {
        return new PlainComponentSerializerImpl.BuilderImpl(this.flattener);
    }

    public static interface Builder
    extends Buildable.Builder<PlainComponentSerializer> {
        public @NonNull Builder flattener(@NonNull ComponentFlattener var1);
    }
}

