/*
 * Decompiled with CFR 0.152.
 */
package net.kyori.mammoth.test;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.kyori.mammoth.test.GradleFunctionalTest;
import net.kyori.mammoth.test.GradleParameters;
import net.kyori.mammoth.test.TemplateInvocationExtensions;
import net.kyori.mammoth.test.TestContext;
import net.kyori.mammoth.test.TestVariant;
import net.kyori.mammoth.test.TestVariantResource;
import org.gradle.util.GradleVersion;
import org.junit.jupiter.api.extension.Extension;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.TestTemplateInvocationContext;
import org.junit.jupiter.api.extension.TestTemplateInvocationContextProvider;
import org.junit.platform.commons.support.AnnotationSupport;

class GradleFunctionalTestExtension
implements TestTemplateInvocationContextProvider {
    GradleFunctionalTestExtension() {
    }

    public boolean supportsTestTemplate(ExtensionContext context) {
        Optional method = context.getTestMethod();
        if (!method.isPresent()) {
            return false;
        }
        return AnnotationSupport.isAnnotated((Optional)method, GradleFunctionalTest.class);
    }

    public Stream<TestTemplateInvocationContext> provideTestTemplateInvocationContexts(ExtensionContext context) {
        Optional parameters = AnnotationSupport.findAnnotation((Optional)context.getElement(), GradleParameters.class);
        List variants = AnnotationSupport.findRepeatableAnnotations((Optional)context.getElement(), TestVariant.class);
        List variantSources = AnnotationSupport.findRepeatableAnnotations((Optional)context.getElement(), TestVariantResource.class);
        String[] commonArgs = parameters.map(GradleParameters::value).orElse(new String[0]);
        if (variants.isEmpty() && variantSources.isEmpty()) {
            return Stream.of(this.produce(context, commonArgs, "", new String[0]));
        }
        Stream<TestTemplateInvocationContext> directVariants = variants.stream().map(variant -> this.produce(context, commonArgs, variant.gradleVersion(), variant.extraArguments()));
        Stream<TestTemplateInvocationContext> resourceVariants = variantSources.stream().flatMap(source -> this.readLines(source.value(), context.getRequiredTestClass().getResource(source.value()), source.optional())).filter(arr -> ((String[])arr).length > 0).map(line -> this.produce(context, commonArgs, line[0], ((String[])line).length > 1 ? line[1].split(" ", -1) : new String[]{}));
        return Stream.concat(directVariants, resourceVariants);
    }

    private Stream<String[]> readLines(String name, @Nullable URL uri, boolean optional) {
        InputStreamReader reader;
        if (uri == null) {
            if (optional) {
                return Stream.empty();
            }
            throw new IllegalArgumentException("Unable to find resource '" + name + "'");
        }
        try {
            reader = new InputStreamReader(uri.openStream(), StandardCharsets.UTF_8);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        BufferedReader buf = new BufferedReader(reader);
        return (Stream)buf.lines().filter(l -> !l.isEmpty()).map(s -> s.split(":", -1)).onClose(() -> {
            try {
                buf.close();
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        });
    }

    private TestTemplateInvocationContext produce(ExtensionContext context, String[] commonArgs, String gradleVersion, String ... extraArguments) {
        Path tempDirectory;
        final List<String> extraArgs = GradleFunctionalTestExtension.processArgs(commonArgs, extraArguments);
        try {
            tempDirectory = Files.createTempDirectory(context.getRequiredTestClass().getSimpleName(), new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        final TestContext testContext = new TestContext(context.getRequiredTestClass(), context.getDisplayName(), tempDirectory, gradleVersion.isEmpty() ? GradleVersion.current().getVersion() : gradleVersion, extraArgs);
        return new TestTemplateInvocationContext(){

            public String getDisplayName(int invocationIndex) {
                return "gradle " + testContext.gradleVersion() + ", args=" + extraArgs;
            }

            public List<Extension> getAdditionalExtensions() {
                return Collections.singletonList(new TemplateInvocationExtensions(testContext));
            }
        };
    }

    private static List<String> processArgs(String[] common, String[] extra) {
        ArrayList<String> ret = new ArrayList<String>(common.length + extra.length);
        Collections.addAll(ret, common);
        Collections.addAll(ret, extra);
        return ret;
    }
}

