/*
 * Decompiled with CFR 0.152.
 */
package net.kyori.mammoth.test;

import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import net.kyori.mammoth.test.TestContext;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolutionException;
import org.junit.jupiter.api.extension.ParameterResolver;

class TemplateInvocationExtensions
implements AfterEachCallback,
ParameterResolver {
    private final TestContext context;

    TemplateInvocationExtensions(TestContext context) {
        this.context = context;
    }

    public void afterEach(ExtensionContext context) throws Exception {
        try {
            Files.walkFileTree(this.context.outputDirectory(), DeletingFileVisitor.INSTANCE);
        }
        catch (IOException ex) {
            System.err.println("Failed to delete temporary directory for test " + this.getClass().getSimpleName());
            ex.printStackTrace();
        }
    }

    public boolean supportsParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        return TestContext.class.isAssignableFrom(parameterContext.getParameter().getType());
    }

    public Object resolveParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        return this.context;
    }

    static final class DeletingFileVisitor
    extends SimpleFileVisitor<Path> {
        static final DeletingFileVisitor INSTANCE = new DeletingFileVisitor();

        private DeletingFileVisitor() {
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
            Files.deleteIfExists(file);
            return super.visitFile(file, attrs);
        }

        @Override
        public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
            Files.deleteIfExists(dir);
            return super.postVisitDirectory(dir, exc);
        }
    }
}

