/*
 * Decompiled with CFR 0.152.
 */
package net.kyori.mammoth.test;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.regex.Pattern;
import org.gradle.testkit.runner.BuildResult;
import org.gradle.testkit.runner.GradleRunner;
import org.jetbrains.annotations.NotNull;
import org.junit.jupiter.api.Assertions;

public final class TestContext {
    private static final Pattern LINE_ENDING = Pattern.compile("\r\n");
    private final Class<?> resourceBase;
    private final String testName;
    private final Path outputDirectory;
    private final String gradleVersion;
    private final List<String> commonArguments;

    TestContext(Class<?> resourceBase, String testName, Path outputDirectory, String gradleVersion, List<String> commonArguments) {
        this.resourceBase = resourceBase;
        this.testName = testName;
        this.outputDirectory = outputDirectory;
        this.gradleVersion = gradleVersion;
        this.commonArguments = commonArguments;
    }

    @NotNull
    public Path outputDirectory() {
        return this.outputDirectory;
    }

    @NotNull
    String gradleVersion() {
        return this.gradleVersion;
    }

    public void copyInput(@NotNull String name) throws IOException {
        this.copyInput(name, name);
    }

    public void copyInput(@NotNull String fromName, @NotNull String toName) throws IOException {
        Objects.requireNonNull(fromName, "fromName");
        Objects.requireNonNull(toName, "toName");
        try (InputStream is = this.resourceBase.getResourceAsStream(this.testName + "/in/" + fromName);){
            Assertions.assertNotNull((Object)is, () -> "No resource found with name " + fromName);
            Path destination = this.outputDirectory.resolve(toName);
            Files.createDirectories(destination.getParent(), new FileAttribute[0]);
            try (OutputStream os = Files.newOutputStream(destination, new OpenOption[0]);){
                int read;
                byte[] buffer = new byte[8192];
                while ((read = is.read(buffer)) != -1) {
                    os.write(buffer, 0, read);
                }
            }
        }
    }

    @NotNull
    public String readOutput(@NotNull String fileName) throws IOException {
        StringBuilder builder = new StringBuilder();
        try (BufferedReader reader = Files.newBufferedReader(this.outputDirectory.resolve(fileName), StandardCharsets.UTF_8);){
            int read;
            char[] buffer = new char[8192];
            while ((read = reader.read(buffer)) != -1) {
                builder.append(buffer, 0, read);
            }
        }
        return TestContext.normalizeLineEndings(builder.toString());
    }

    public void assertOutputEquals(@NotNull String resourceName, @NotNull String fileName) throws IOException {
        String actualOutput = this.readOutput(fileName);
        StringBuilder builder = new StringBuilder();
        InputStream is = this.resourceBase.getResourceAsStream(this.testName + "/out/" + resourceName);
        Assertions.assertNotNull((Object)is, () -> "No resource found with name " + resourceName);
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8));){
            int read;
            char[] buffer = new char[8192];
            while ((read = reader.read(buffer)) != -1) {
                builder.append(buffer, 0, read);
            }
        }
        String expected = TestContext.normalizeLineEndings(builder.toString());
        Assertions.assertEquals((Object)expected, (Object)actualOutput);
    }

    @NotNull
    public GradleRunner runner(String ... extraArgs) {
        ArrayList<String> args = new ArrayList<String>(this.commonArguments.size() + extraArgs.length);
        args.addAll(this.commonArguments);
        Collections.addAll(args, extraArgs);
        return GradleRunner.create().withGradleVersion(this.gradleVersion).withPluginClasspath().withProjectDir(this.outputDirectory.toFile()).withArguments(args);
    }

    @NotNull
    public BuildResult build(String ... extraArgs) {
        return this.runner(extraArgs).build();
    }

    static String normalizeLineEndings(String input) {
        return LINE_ENDING.matcher(input).replaceAll("\n");
    }
}

