/*
 * Decompiled with CFR 0.152.
 */
package net.kyori.mammoth;

import java.util.Objects;
import org.gradle.api.Action;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class Configurable {
    private Configurable() {
    }

    @NotNull
    public static <T> T configure(@NotNull T instance, @NotNull Action<T> configureAction) {
        Objects.requireNonNull(configureAction, "configureAction").execute(instance);
        return instance;
    }

    @NotNull
    public static <T> T configureIfNonNull(@NotNull T instance, @Nullable Action<T> configureAction) {
        if (configureAction != null) {
            configureAction.execute(instance);
        }
        return instance;
    }
}

