/*
 * Decompiled with CFR 0.152.
 */
package net.kyori.mammoth;

import net.kyori.mammoth.GradleCompat;
import org.gradle.api.GradleException;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.initialization.Settings;
import org.gradle.api.invocation.Gradle;
import org.gradle.api.plugins.ExtensionContainer;
import org.gradle.api.plugins.PluginContainer;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.util.GradleVersion;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface ProjectOrSettingsPlugin
extends Plugin<Object> {
    default public void apply(@NotNull Object target) {
        if (target instanceof Project) {
            Project project = (Project)target;
            GradleCompat.requireMinimumVersion(this.minimumGradleVersion(), this, project.getDisplayName());
            this.applyToProject(project, project.getPlugins(), project.getExtensions(), project.getTasks());
        } else if (target instanceof Settings) {
            Settings settings = (Settings)target;
            GradleCompat.requireMinimumVersion(this.minimumGradleVersion(), this, "settings");
            this.applyToSettings(settings, settings.getPlugins(), settings.getExtensions());
            settings.getGradle().getPlugins().apply(this.getClass());
        } else if (!(target instanceof Gradle)) {
            throw new GradleException("Plugin " + this.getClass() + " target '" + target + "' is of unexpected type " + target.getClass() + ". We were expecting a Project or Settings instance.");
        }
    }

    public void applyToProject(@NotNull Project var1, @NotNull PluginContainer var2, @NotNull ExtensionContainer var3, @NotNull TaskContainer var4);

    public void applyToSettings(@NotNull Settings var1, @NotNull PluginContainer var2, @NotNull ExtensionContainer var3);

    @Nullable
    default public GradleVersion minimumGradleVersion() {
        return null;
    }

    default public boolean isAppliedToSettingsOf(@NotNull Project project) {
        return project.getGradle().getPlugins().hasPlugin(this.getClass());
    }
}

