/*
 * Decompiled with CFR 0.152.
 */
package net.kyori.mammoth;

import org.gradle.api.GradleException;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.provider.Provider;
import org.gradle.util.GradleVersion;
import org.jetbrains.annotations.Nullable;

final class GradleCompat {
    static final boolean SHOULD_USE_CONVENTION = GradleCompat.hasMethod(Project.class, "getConvention", new Class[0]) && !GradleCompat.hasMinGradleVersion("8.2");
    static final boolean HAS_FOR_USE_AT_CONFIGURATION_TIME = GradleCompat.hasMethod(Provider.class, "forUseAtConfigurationTime", new Class[0]) && !GradleCompat.hasMinGradleVersion("7.6");

    private GradleCompat() {
    }

    private static boolean hasMethod(Class<?> clazz, String name, Class<?> ... args) {
        try {
            clazz.getMethod(name, args);
            return true;
        }
        catch (NoSuchMethodException ex) {
            return false;
        }
    }

    static boolean hasMinGradleVersion(String version) {
        return GradleVersion.current().getBaseVersion().compareTo(GradleVersion.version((String)version)) >= 0;
    }

    static void requireMinimumVersion(@Nullable GradleVersion minimum, Plugin<?> plugin, String targetDisplayName) {
        GradleVersion current;
        if (minimum != null && (current = GradleVersion.current()).compareTo(minimum) < 0) {
            throw new GradleException("Your Gradle version is too old to apply the plugin from " + plugin.getClass().getName() + " to " + targetDisplayName + "\n    Minimum: " + minimum + "\n    Current: " + current + "\n");
        }
    }
}

