/*
 * Decompiled with CFR 0.152.
 */
package net.kyori.mammoth;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Iterator;
import java.util.Set;
import net.kyori.mammoth.IsolatingClassLoaderImpl;
import org.gradle.api.file.FileCollection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class IsolatingClassLoader {
    private IsolatingClassLoader() {
    }

    @NotNull
    public static URLClassLoader isolatingClassLoader(@Nullable ClassLoader parent, URL ... urls) {
        return new IsolatingClassLoaderImpl(urls, parent);
    }

    @NotNull
    public static URLClassLoader isolatingClassLoader(@Nullable ClassLoader parent, @NotNull FileCollection files) {
        Set unwrapped = files.getFiles();
        URL[] urls = new URL[unwrapped.size()];
        Iterator it = files.iterator();
        int idx = 0;
        while (it.hasNext()) {
            File file = (File)it.next();
            try {
                urls[idx++] = file.toURI().toURL();
            }
            catch (MalformedURLException ex) {
                throw new IllegalArgumentException("Unable to include file " + file + " in classpath");
            }
        }
        return new IsolatingClassLoaderImpl(urls, parent);
    }
}

