/*
 * Decompiled with CFR 0.152.
 */
package net.kyori.moonshine.internal;

import io.leangen.geantyref.GenericTypeReflector;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.Arrays;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import net.kyori.moonshine.internal.ThrowableUtils;

public final class ReflectiveUtils {
    private static final ConcurrentMap<Method, MethodHandle> METHOD_CACHE = new ConcurrentHashMap<Method, MethodHandle>();

    private ReflectiveUtils() {
    }

    public static MethodHandle findMethod(Method method, Object proxy) throws IllegalAccessException {
        Class<?> type = method.getDeclaringClass();
        return METHOD_CACHE.computeIfAbsent(method, methodParam -> {
            try {
                return MethodHandles.privateLookupIn(method.getDeclaringClass(), MethodHandles.lookup()).findSpecial(type, method.getName(), MethodType.methodType(method.getReturnType(), method.getParameterTypes()), type).bindTo(proxy);
            }
            catch (IllegalAccessException | NoSuchMethodException ex) {
                ThrowableUtils.sneakyThrow(ex);
                throw new RuntimeException(ex);
            }
        });
    }

    public static String formatMethodName(Type owner, Method method) {
        return GenericTypeReflector.getTypeName((Type)owner) + "#" + method.getName() + ReflectiveUtils.formatMethodTypeParameters(method) + "(" + ReflectiveUtils.formatMethodParameters(method) + ")" + GenericTypeReflector.getTypeName((Type)method.getGenericReturnType());
    }

    private static String formatMethodParameters(Method method) {
        if (method.getParameterCount() == 0) {
            return "";
        }
        return Arrays.stream(method.getGenericParameterTypes()).map(GenericTypeReflector::getTypeName).collect(Collectors.joining(", "));
    }

    private static String formatMethodTypeParameters(Method method) {
        TypeVariable<Method>[] typeParameters = method.getTypeParameters();
        if (typeParameters.length == 0) {
            return "";
        }
        return Arrays.stream(typeParameters).map(GenericTypeReflector::getTypeName).collect(Collectors.joining(", ", "<", ">"));
    }
}

