/*
 * Decompiled with CFR 0.152.
 */
package net.kyori.moonshine.strategy;

import io.leangen.geantyref.GenericTypeReflector;
import java.lang.reflect.Executable;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import net.kyori.moonshine.Moonshine;
import net.kyori.moonshine.annotation.Placeholder;
import net.kyori.moonshine.exception.PlaceholderResolvingException;
import net.kyori.moonshine.exception.UnfinishedPlaceholderException;
import net.kyori.moonshine.internal.PrefixedDelegateIterator;
import net.kyori.moonshine.model.MoonshineMethod;
import net.kyori.moonshine.placeholder.ContinuanceValue;
import net.kyori.moonshine.placeholder.IPlaceholderResolver;
import net.kyori.moonshine.strategy.IPlaceholderResolverStrategy;
import net.kyori.moonshine.strategy.supertype.ISupertypeStrategy;
import net.kyori.moonshine.util.Weighted;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class StandardPlaceholderResolverStrategy<R, I, F>
implements IPlaceholderResolverStrategy<R, I, F> {
    private final ISupertypeStrategy supertypeStrategy;

    public StandardPlaceholderResolverStrategy(ISupertypeStrategy supertypeStrategy) {
        this.supertypeStrategy = supertypeStrategy;
    }

    public Map<String, ? extends F> resolvePlaceholders(Moonshine<R, I, ?, F> moonshine, R receiver, I intermediateText, MoonshineMethod<? extends R> moonshineMethod, @Nullable Object[] parameters) throws PlaceholderResolvingException {
        if (parameters.length == 0) {
            return Collections.emptyMap();
        }
        LinkedHashMap finalisedPlaceholders = new LinkedHashMap(parameters.length);
        LinkedHashMap resolvingPlaceholders = new LinkedHashMap(16);
        Parameter[] methodParameters = moonshineMethod.reflectMethod().getParameters();
        Type[] exactParameterTypes = GenericTypeReflector.getParameterTypes((Executable)moonshineMethod.reflectMethod(), (Type)moonshine.proxiedType());
        for (int idx = 0; idx < parameters.length; ++idx) {
            Parameter parameter = methodParameters[idx];
            Object value = parameters[idx];
            if (value == null) continue;
            Type parameterType = GenericTypeReflector.getExactSubType((Type)exactParameterTypes[idx], value.getClass());
            @Nullable Placeholder placeholder = parameter.getAnnotation(Placeholder.class);
            if (placeholder == null) continue;
            String placeholderName = placeholder.value().isEmpty() ? parameter.getName() : placeholder.value();
            resolvingPlaceholders.put(placeholderName, ContinuanceValue.continuanceValue((Object)value, (Type)parameterType));
        }
        this.resolvePlaceholder(moonshine, receiver, finalisedPlaceholders, resolvingPlaceholders, moonshineMethod, parameters);
        return finalisedPlaceholders;
    }

    private void resolvePlaceholder(Moonshine<R, I, ?, F> moonshine, R receiver, Map<String, F> finalisedPlaceholders, Map<String, ContinuanceValue<?>> resolvingPlaceholders, MoonshineMethod<? extends R> moonshineMethod, @Nullable Object[] parameters) throws UnfinishedPlaceholderException {
        Map weightedPlaceholderResolvers = moonshine.weightedPlaceholderResolvers();
        block0: while (!resolvingPlaceholders.isEmpty()) {
            Iterator<Map.Entry<String, ContinuanceValue<?>>> resolvingPlaceholderIterator = resolvingPlaceholders.entrySet().iterator();
            if (!resolvingPlaceholderIterator.hasNext()) continue;
            Map.Entry<String, ContinuanceValue<?>> continuanceEntry = resolvingPlaceholderIterator.next();
            String continuancePlaceholderName = continuanceEntry.getKey();
            Type type = continuanceEntry.getValue().type();
            Object value = continuanceEntry.getValue().value();
            PrefixedDelegateIterator hierarchyIterator = new PrefixedDelegateIterator((Object)type, this.supertypeStrategy.hierarchyIterator(type));
            while (hierarchyIterator.hasNext()) {
                Type supertype = (Type)hierarchyIterator.next();
                for (Weighted weighted : weightedPlaceholderResolvers.getOrDefault(supertype, Collections.emptyNavigableSet())) {
                    IPlaceholderResolver placeholderResolver = (IPlaceholderResolver)weighted.value();
                    Map resolverResult = placeholderResolver.resolve(continuancePlaceholderName, value, receiver, moonshineMethod.owner().getType(), moonshineMethod.reflectMethod(), parameters);
                    if (resolverResult == null) continue;
                    resolvingPlaceholderIterator.remove();
                    resolverResult.forEach((resolvedName, resolvedValue) -> resolvedValue.map(conclusionValue -> finalisedPlaceholders.put((String)resolvedName, (Object)conclusionValue.value()), continuanceValue -> resolvingPlaceholders.put((String)resolvedName, (ContinuanceValue<?>)continuanceValue)));
                    continue block0;
                }
            }
            throw new UnfinishedPlaceholderException(moonshineMethod, continuancePlaceholderName, value);
        }
    }
}

