/*
 * Decompiled with CFR 0.152.
 */
package net.kyori.moonshine.strategy.supertype;

import io.leangen.geantyref.GenericTypeReflector;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Stream;
import net.kyori.moonshine.strategy.supertype.ISupertypeStrategy;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class StandardSupertypeThenInterfaceSupertypeStrategy
implements ISupertypeStrategy {
    private final ConcurrentMap<Type, LinkedHashSet<Type>> typeToHierarchyCache = new ConcurrentHashMap<Type, LinkedHashSet<Type>>();
    private final boolean returnObject;

    public StandardSupertypeThenInterfaceSupertypeStrategy(boolean returnObject) {
        this.returnObject = returnObject;
    }

    @Override
    public Iterator<Type> hierarchyIterator(Type type) {
        Class erasedBaseType = GenericTypeReflector.erase((Type)type);
        if (erasedBaseType == Object.class) {
            Set<Class<Object>> types = Collections.singleton(Object.class);
            return types.iterator();
        }
        return this.typeToHierarchyCache.computeIfAbsent(type, key -> {
            LinkedHashSet<Type> aggregatedSuperTypes = this.aggregateSuperTypes(type);
            LinkedHashSet<Type> aggregatedSuperInterfaces = this.aggregateSuperInterfaces(Stream.concat(Stream.of(type), aggregatedSuperTypes.stream()), type);
            LinkedHashSet<Type> conjoined = new LinkedHashSet<Type>(aggregatedSuperTypes.size() + aggregatedSuperInterfaces.size());
            conjoined.addAll(aggregatedSuperTypes);
            conjoined.addAll(aggregatedSuperInterfaces);
            return conjoined;
        }).iterator();
    }

    private LinkedHashSet<Type> aggregateSuperTypes(Type baseType) {
        LinkedHashSet<Type> types = new LinkedHashSet<Type>();
        @Nullable Class<T> erasedSuperType = GenericTypeReflector.erase((Type)baseType);
        while ((erasedSuperType = erasedSuperType.getSuperclass()) != null && (this.returnObject || erasedSuperType != Object.class)) {
            types.add(GenericTypeReflector.getExactSuperType((Type)baseType, erasedSuperType));
        }
        return types;
    }

    private LinkedHashSet<Type> aggregateSuperInterfaces(Stream<Type> aggregatedSuperTypes, Type baseType) {
        LinkedHashSet<Type> types = new LinkedHashSet<Type>();
        Iterator superTypes = aggregatedSuperTypes.iterator();
        while (superTypes.hasNext()) {
            Class<?>[] interfaces;
            Type superType = (Type)superTypes.next();
            for (Class<?> iface : interfaces = GenericTypeReflector.erase((Type)superType).getInterfaces()) {
                @Nullable Type exact = GenericTypeReflector.getExactSuperType((Type)baseType, iface);
                types.add(Objects.requireNonNullElse(exact, iface));
            }
            for (Class<?> iface : interfaces) {
                types.addAll(this.aggregateSuperInterfaces(Stream.of(iface), baseType));
            }
        }
        return types;
    }
}

