/*
 * Decompiled with CFR 0.152.
 */
package net.kyori.regionfile;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.file.Path;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.InflaterInputStream;
import org.checkerframework.checker.nullness.qual.Nullable;

public class RegionFile
implements AutoCloseable {
    private static final int VERSION_GZIP = 1;
    private static final int VERSION_DEFLATE = 2;
    private static final int SECTOR_BYTES = 4096;
    private static final int SECTOR_INTS = 1024;
    private static final byte[] EMPTY_SECTOR = new byte[4096];
    static final int CHUNK_HEADER_SIZE = 5;
    private final int[] offsets = new int[1024];
    private final int[] chunkTimestamps = new int[1024];
    private final RandomAccessFile file;
    private final List<Boolean> sectorFree;
    private int sizeDelta;
    private long lastModified;

    public RegionFile(Path path) throws IOException {
        this(path.toFile());
    }

    public RegionFile(File file) throws IOException {
        int i;
        if (file.exists()) {
            this.lastModified = file.lastModified();
        }
        this.file = new RandomAccessFile(file, "rw");
        if (this.file.length() < 4096L) {
            this.file.write(EMPTY_SECTOR);
            this.file.write(EMPTY_SECTOR);
            this.sizeDelta += 8192;
        }
        if ((this.file.length() & 0xFFFL) != 0L) {
            int i2 = 0;
            while ((long)i2 < (this.file.length() & 0xFFFL)) {
                this.file.write(0);
                ++i2;
            }
        }
        int nSectors = (int)this.file.length() / 4096;
        this.sectorFree = new ArrayList<Boolean>(nSectors);
        for (i = 0; i < nSectors; ++i) {
            this.sectorFree.add(true);
        }
        this.sectorFree.set(0, false);
        this.sectorFree.set(1, false);
        this.file.seek(0L);
        for (i = 0; i < 1024; ++i) {
            int offset;
            this.offsets[i] = offset = this.file.readInt();
            if (offset == 0 || (offset >> 8) + (offset & 0xFF) > this.sectorFree.size()) continue;
            for (int sectorNum = 0; sectorNum < (offset & 0xFF); ++sectorNum) {
                this.sectorFree.set((offset >> 8) + sectorNum, false);
            }
        }
        for (i = 0; i < 1024; ++i) {
            int lastModValue;
            this.chunkTimestamps[i] = lastModValue = this.file.readInt();
        }
    }

    public boolean has(int x, int z) {
        return this.getOffset(x, z) != 0;
    }

    public synchronized @Nullable DataInputStream read(int x, int z) throws IOException {
        if (RegionFile.outOfBounds(x, z)) {
            return null;
        }
        int offset = this.getOffset(x, z);
        if (offset == 0) {
            return null;
        }
        int sectorNumber = offset >> 8;
        int numSectors = offset & 0xFF;
        if (sectorNumber + numSectors > this.sectorFree.size()) {
            return null;
        }
        this.file.seek(sectorNumber * 4096);
        int length = this.file.readInt();
        if (length > 4096 * numSectors) {
            return null;
        }
        if (length <= 0) {
            return null;
        }
        byte version = this.file.readByte();
        if (version == 1) {
            byte[] data = new byte[length - 1];
            this.file.read(data);
            return new DataInputStream(new BufferedInputStream(new GZIPInputStream(new ByteArrayInputStream(data))));
        }
        if (version == 2) {
            byte[] data = new byte[length - 1];
            this.file.read(data);
            return new DataInputStream(new BufferedInputStream(new InflaterInputStream(new ByteArrayInputStream(data))));
        }
        return null;
    }

    public @Nullable DataOutputStream write(int x, int z) {
        if (RegionFile.outOfBounds(x, z)) {
            return null;
        }
        return new DataOutputStream(new BufferedOutputStream(new DeflaterOutputStream(new ChunkBuffer(x, z))));
    }

    protected synchronized void write(int x, int z, byte[] data, int length) throws IOException {
        int offset = this.getOffset(x, z);
        int sectorNumber = offset >> 8;
        int sectorsAllocated = offset & 0xFF;
        int sectorsNeeded = (length + 5) / 4096 + 1;
        if (sectorsNeeded >= 256) {
            return;
        }
        if (sectorNumber != 0 && sectorsAllocated == sectorsNeeded) {
            this.write(sectorNumber, data, length);
        } else {
            int i;
            for (int i2 = 0; i2 < sectorsAllocated; ++i2) {
                this.sectorFree.set(sectorNumber + i2, true);
            }
            int runStart = this.sectorFree.indexOf(true);
            int runLength = 0;
            if (runStart != -1) {
                for (i = runStart; i < this.sectorFree.size(); ++i) {
                    if (runLength != 0) {
                        runLength = this.sectorFree.get(i).booleanValue() ? ++runLength : 0;
                    } else if (this.sectorFree.get(i).booleanValue()) {
                        runStart = i;
                        runLength = 1;
                    }
                    if (runLength >= sectorsNeeded) break;
                }
            }
            if (runLength >= sectorsNeeded) {
                sectorNumber = runStart;
                this.setOffset(x, z, sectorNumber << 8 | sectorsNeeded);
                for (i = 0; i < sectorsNeeded; ++i) {
                    this.sectorFree.set(sectorNumber + i, false);
                }
                this.write(sectorNumber, data, length);
            } else {
                this.file.seek(this.file.length());
                sectorNumber = this.sectorFree.size();
                for (i = 0; i < sectorsNeeded; ++i) {
                    this.file.write(EMPTY_SECTOR);
                    this.sectorFree.add(false);
                }
                this.sizeDelta += 4096 * sectorsNeeded;
                this.write(sectorNumber, data, length);
                this.setOffset(x, z, sectorNumber << 8 | sectorsNeeded);
            }
        }
        this.setTimestamp(x, z, (int)(Instant.now().toEpochMilli() / 1000L));
    }

    private void write(int sectorNumber, byte[] data, int length) throws IOException {
        this.file.seek(sectorNumber * 4096);
        this.file.writeInt(length + 1);
        this.file.writeByte(2);
        this.file.write(data, 0, length);
    }

    private int getOffset(int x, int z) {
        return this.offsets[x + z * 32];
    }

    private void setOffset(int x, int z, int offset) throws IOException {
        this.offsets[x + z * 32] = offset;
        this.file.seek((x + z * 32) * 4);
        this.file.writeInt(offset);
    }

    private void setTimestamp(int x, int z, int value) throws IOException {
        this.chunkTimestamps[x + z * 32] = value;
        this.file.seek(4096 + (x + z * 32) * 4);
        this.file.writeInt(value);
    }

    private static boolean outOfBounds(int x, int z) {
        return x < 0 || x >= 32 || z < 0 || z >= 32;
    }

    @Override
    public void close() throws IOException {
        if (this.file != null) {
            this.file.close();
        }
    }

    class ChunkBuffer
    extends ByteArrayOutputStream {
        private final int x;
        private final int z;

        ChunkBuffer(int x, int z) {
            super(8096);
            this.x = x;
            this.z = z;
        }

        @Override
        public void close() throws IOException {
            RegionFile.this.write(this.x, this.z, this.buf, this.count);
        }
    }
}

