/*
 * This file is part of storm, licensed under the MIT License.
 *
 * Copyright (c) 2017 KyoriPowered
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */
package net.kyori.storm.plugin;

import net.kyori.blizzard.NonNull;
import net.kyori.blizzard.Nullable;

import java.util.Collection;

/**
 * A plugin finder.
 */
public interface PluginFinder {
  /**
   * Gets a collection of all plugins.
   *
   * @return a collection of plugins
   */
  @NonNull
  Collection<PluginContainer> all();

  /**
   * Finds a plugin by the specified id.
   *
   * @param id the id
   * @return the plugin, or {@code null} if no plugin with the specified id could be found
   */
  @Nullable
  PluginContainer find(@NonNull final String id);
}
