/*
 * This file is part of storm, licensed under the MIT License.
 *
 * Copyright (c) 2017 KyoriPowered
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */
package net.kyori.storm.util;

import net.kyori.blizzard.NonNull;
import net.kyori.lunar.exception.Exceptions;

import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Path;

/**
 * A bridge to a {@link ClassLoader} which can have {@link URL}s inserted.
 */
public interface ClassLoaderInjector {
  /**
   * Gets the classloader.
   *
   * @return the classloader
   */
  @NonNull
  ClassLoader classLoader();

  /**
   * Add a path to the classloader.
   *
   * @param path the path
   */
  default void addPath(@NonNull final Path path) {
    try {
      this.addURL(path.toUri().toURL());
    } catch(final MalformedURLException e) {
      throw Exceptions.rethrow(e);
    }
  }

  /**
   * Add a url to the classloader.
   *
   * @param url the url
   */
  void addURL(@NonNull final URL url);
}
