/*
 * Decompiled with CFR 0.152.
 */
package net.kyori.storm.plugin;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import net.kyori.blizzard.NonNull;
import net.kyori.storm.plugin.ModularPlugin;
import net.kyori.storm.plugin.PluginContainer;

final class PluginContainerImpl
implements PluginContainer {
    private final Class<?> klass;
    private final String id;
    private final String version;
    private State state = State.CONSTRUCT;
    private Object instance;

    PluginContainerImpl(Class<?> klass, String id, String version) {
        this.klass = klass;
        this.id = id;
        this.version = version;
    }

    void construct() throws IllegalAccessException, InstantiationException {
        this.expectState(State.CONSTRUCT);
        this.instance = this.klass.newInstance();
        this.state = State.ENABLE;
    }

    void enable() {
        this.expectState(State.ENABLE);
        if (this.instance instanceof ModularPlugin) {
            ((ModularPlugin)this.instance).enable();
        }
        this.state = State.ACTIVE;
    }

    void disable() {
        this.expectState(State.ACTIVE);
        if (this.instance instanceof ModularPlugin) {
            ((ModularPlugin)this.instance).disable();
        }
        this.state = null;
    }

    private void expectState(State expected) {
        Preconditions.checkState((this.state != null ? 1 : 0) != 0, (Object)"container is in an invalid state");
        Preconditions.checkState((this.state == expected ? 1 : 0) != 0, (String)"expected container state to be %s, was %s", (Object)((Object)expected), (Object)((Object)this.state));
    }

    @Override
    @NonNull
    public String id() {
        return this.id;
    }

    @Override
    @NonNull
    public String version() {
        return this.version;
    }

    @Override
    @NonNull
    public Object instance() {
        return this.instance;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("klass", this.klass).add("id", (Object)this.id).add("version", (Object)this.version).add("state", (Object)this.state).toString();
    }

    private static enum State {
        CONSTRUCT,
        ENABLE,
        ACTIVE;

    }
}

