/*
 * Decompiled with CFR 0.152.
 */
package net.kyori.storm.plugin;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.base.Suppliers;
import com.google.common.collect.Lists;
import com.google.common.graph.EndpointPair;
import com.google.common.graph.GraphBuilder;
import com.google.common.graph.MutableGraph;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.DirectoryStream;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.stream.Collectors;
import net.kyori.blizzard.NonNull;
import net.kyori.blizzard.Nullable;
import net.kyori.lunar.exception.Exceptions;
import net.kyori.storm.plugin.PluginContainer;
import net.kyori.storm.plugin.PluginContainerImpl;
import net.kyori.storm.plugin.PluginFinder;
import net.kyori.storm.util.ClassLoaderInjector;
import net.kyori.version.ArtifactVersion;
import net.kyori.version.DefaultArtifactVersion;
import net.kyori.version.InvalidVersionSpecificationException;
import net.kyori.version.VersionRange;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PluginLoader
implements PluginFinder {
    private static final Logger LOGGER = LoggerFactory.getLogger(PluginLoader.class);
    private static final String PLUGIN_DEFINITION_TYPE = "Lnet/kyori/storm/plugin/Plugin;";
    private static final String DEPENDENCY_DEFINITION_TYPE = "Lnet/kyori/storm/plugin/Plugin$Dependency;";
    private static final String CLASS_EXTENSION = ".class";
    private static final String JAR_EXTENSION = ".jar";
    private static final String FILE_PROTOCOL = "file";
    private static final String JAVA_HOME = System.getProperty("java.home");
    private final List<Candidate> candidates = new ArrayList<Candidate>();
    private final List<PluginContainerImpl> containers = new ArrayList<PluginContainerImpl>();
    private final Map<String, PluginContainerImpl> namedContainers = new HashMap<String, PluginContainerImpl>();
    private final Supplier<SimpleFileVisitor<Path>> classPathVisitor = Suppliers.memoize(() -> new SimpleFileVisitor<Path>(){

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
            if (!file.toString().endsWith(PluginLoader.CLASS_EXTENSION)) {
                return FileVisitResult.CONTINUE;
            }
            try (InputStream is = Files.newInputStream(file, new OpenOption[0]);){
                PluginLoader.this.find(Source.CLASSPATH, is);
            }
            return FileVisitResult.CONTINUE;
        }
    });
    @NonNull
    private final ClassLoaderInjector classLoaderInjector;
    private State state = State.FIND;

    public PluginLoader(@NonNull ClassLoaderInjector classLoaderInjector) {
        this.classLoaderInjector = classLoaderInjector;
    }

    public void findAll(@NonNull Path directory) throws IOException {
        this.ensureFinding();
        LOGGER.debug("Searching directory '{}' for plugin candidates...", (Object)directory.toAbsolutePath());
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(directory, entry -> entry.toString().endsWith(JAR_EXTENSION));){
            for (Path path : stream) {
                this.find(path);
            }
        }
    }

    public void findClassPath(@NonNull URLClassLoader loader) throws IOException {
        this.ensureFinding();
        LOGGER.debug("Searching classpath of classloader '{}' for plugin candidates...", (Object)loader);
        Arrays.stream(loader.getURLs()).filter(url -> url.getProtocol().equals(FILE_PROTOCOL)).filter(url -> !url.getProtocol().startsWith(JAVA_HOME)).map(Exceptions.rethrowFunction(URL::toURI)).map(Paths::get).forEach(Exceptions.rethrowConsumer(path -> {
            if (Files.isDirectory(path, new LinkOption[0])) {
                Files.walkFileTree(path, Collections.singleton(FileVisitOption.FOLLOW_LINKS), 50, (FileVisitor<? super Path>)this.classPathVisitor.get());
            } else {
                this.find(Source.CLASSPATH, (Path)path);
            }
        }));
    }

    private void find(@NonNull Path path) throws IOException {
        this.find(Source.path(path), path);
    }

    private void find(@NonNull Source source, @NonNull Path path) throws IOException {
        try (JarFile jar = new JarFile(path.toFile());){
            List entries = Collections.list(jar.entries()).stream().filter(entry -> !entry.isDirectory()).filter(entry -> entry.getName().endsWith(CLASS_EXTENSION)).collect(Collectors.toList());
            for (JarEntry entry2 : entries) {
                InputStream is = jar.getInputStream(entry2);
                Throwable throwable = null;
                try {
                    this.find(source, is);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (is == null) continue;
                    if (throwable != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    is.close();
                }
            }
        }
    }

    private void find(@NonNull Source source, @NonNull InputStream is) throws IOException {
        ClassReader cr = new ClassReader(is);
        cr.accept((ClassVisitor)new Visitor(source), 7);
    }

    public boolean load() {
        if (this.state != State.FIND) {
            throw new IllegalStateException("Candidates have already been loaded into containers");
        }
        this.state = State.CONSTRUCT;
        this.ensureDependenciesSatisfied();
        MutableGraph graph = GraphBuilder.directed().build();
        for (Candidate candidate : this.candidates) {
            graph.addNode((Object)candidate);
            for (Dependency dependency : candidate.dependencies) {
                graph.putEdge((Object)candidate, (Object)dependency.candidate);
            }
        }
        ArrayList<Object> candidates = new ArrayList<Object>(this.candidates.size());
        for (EndpointPair endpointPair : graph.edges()) {
            if (candidates.contains(endpointPair.nodeU()) || candidates.contains(endpointPair.nodeV())) continue;
            candidates.add(endpointPair.nodeV());
            candidates.add(endpointPair.nodeU());
        }
        for (Candidate candidate : candidates) {
            PluginContainerImpl container;
            candidate.source.inject(this.classLoaderInjector);
            try {
                Class<?> klass = Class.forName(candidate.className, true, this.classLoaderInjector.classLoader());
                container = new PluginContainerImpl(klass, candidate.id, candidate.version);
            }
            catch (ClassNotFoundException e) {
                LOGGER.error("Encountered an exception while constructing the container for plugin '{}'", (Object)candidate.id, (Object)e);
                return false;
            }
            try {
                container.construct();
            }
            catch (Throwable t) {
                LOGGER.error("Encountered an exception while constructing plugin '{}'", (Object)container.id(), (Object)t);
                return false;
            }
            this.containers.add(container);
            this.namedContainers.put(container.id(), container);
        }
        this.state = State.ENABLE;
        return true;
    }

    public void enable() {
        this.ensureState(State.ENABLE);
        this.containers.forEach(PluginContainerImpl::enable);
        this.state = State.ACTIVE;
    }

    public void disable() {
        this.ensureState(State.ACTIVE);
        Lists.reverse(this.containers).forEach(PluginContainerImpl::disable);
        this.state = null;
    }

    @Override
    @NonNull
    public Collection<PluginContainer> all() {
        return Collections.unmodifiableList(this.containers);
    }

    @Override
    @Nullable
    public PluginContainer find(@NonNull String id) {
        this.ensureState(State.ACTIVE);
        return this.namedContainers.get(id);
    }

    private void ensureDependenciesSatisfied() {
        Map candidates = this.candidates.stream().collect(Collectors.toMap(input -> input.id, Function.identity()));
        for (Candidate candidate : candidates.values()) {
            for (Dependency dependency : candidate.dependencies) {
                if (candidate.id.equals(dependency.id)) {
                    throw new IllegalStateException(String.format("The plugin '%s' has defined a dependency against itself", candidate.id));
                }
                Candidate dependencyCandidate = (Candidate)candidates.get(dependency.id);
                if (dependencyCandidate == null) {
                    throw new IllegalArgumentException(String.format("The plugin '%s' has defined a dependency on '%s', which is missing", candidate.id, dependency.id));
                }
                if (dependency.version != null && !dependency.version.containsVersion((ArtifactVersion)new DefaultArtifactVersion(dependencyCandidate.version))) {
                    throw new IllegalArgumentException(String.format("The plugin '%s' has defined a dependency on '%s' version '%s', but version '%s' was found", candidate.id, dependency.id, dependency.version.toString(), dependencyCandidate.version));
                }
                dependency.candidate = dependencyCandidate;
            }
        }
    }

    private void ensureFinding() {
        if (this.state != State.FIND) {
            throw new IllegalStateException("Cannot find candidates after containers have been loaded");
        }
    }

    private void ensureState(State expected) {
        Preconditions.checkState((this.state != null ? 1 : 0) != 0, (Object)"loader is in an invalid state");
        Preconditions.checkState((this.state == expected ? 1 : 0) != 0, (String)"expected loader state to be %s, was %s", (Object)((Object)expected), (Object)((Object)this.state));
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("candidates", this.candidates).add("state", (Object)this.state).toString();
    }

    private static interface Source {
        public static final Source CLASSPATH = classLoader -> {};

        @NonNull
        public static Source path(@NonNull Path path) {
            boolean[] inserted = new boolean[]{false};
            return classLoader -> {
                if (!inserted[0]) {
                    inserted[0] = true;
                    classLoader.addPath(path);
                }
            };
        }

        public void inject(@NonNull ClassLoaderInjector var1);
    }

    private final class Dependency {
        @NonNull
        final String id;
        @Nullable
        final VersionRange version;
        Candidate candidate;

        Dependency(@Nullable String id, String version) throws InvalidVersionSpecificationException {
            this.id = id;
            this.version = Strings.emptyToNull((String)version) != null ? VersionRange.createFromVersionSpec((String)version) : null;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("id", (Object)this.id).add("version", (Object)this.version).toString();
        }
    }

    private final class Candidate {
        final Source source;
        final String className;
        final String id;
        final String version;
        final List<Dependency> dependencies;

        Candidate(Source source, String className, String id, String version, List<Dependency> dependencies) {
            this.source = source;
            this.className = className;
            this.id = id;
            this.version = version;
            this.dependencies = dependencies;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("className", (Object)this.className).add("id", (Object)this.id).add("version", (Object)this.version).add("dependencies", this.dependencies).toString();
        }
    }

    private final class Visitor
    extends ClassVisitor {
        private final List<Dependency> dependencies;
        private final Source source;
        private String className;
        private String id;
        private String version;
        private boolean nested;

        Visitor(Source source) {
            super(393216);
            this.dependencies = new ArrayList<Dependency>();
            this.source = source;
        }

        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
            this.className = name.replace('/', '.');
        }

        public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
            if (!visible || !desc.equals(PluginLoader.PLUGIN_DEFINITION_TYPE)) {
                return null;
            }
            return new AnnotationVisitor(393216){

                public void visit(String name, Object value) {
                    switch (name) {
                        case "id": {
                            Visitor.this.id = (String)value;
                            break;
                        }
                        case "version": {
                            Visitor.this.version = (String)value;
                        }
                    }
                }

                public AnnotationVisitor visitAnnotation(String name, String desc) {
                    if (desc.equals(PluginLoader.DEPENDENCY_DEFINITION_TYPE)) {
                        return new AnnotationVisitor(393216){
                            private String id;
                            private String version;

                            public void visit(String name, Object value) {
                                switch (name) {
                                    case "id": {
                                        this.id = (String)value;
                                        break;
                                    }
                                    case "version": {
                                        this.version = (String)value;
                                    }
                                }
                            }

                            public void visitEnd() {
                                try {
                                    Visitor.this.dependencies.add(new Dependency(this.id, this.version));
                                }
                                catch (InvalidVersionSpecificationException e) {
                                    throw new IllegalArgumentException(String.format("The plugin '%s' has defined a dependency on '%s' with an invalid version range of '%s'", Visitor.this.id, this.id, this.version), e);
                                }
                            }
                        };
                    }
                    return super.visitAnnotation(name, desc);
                }

                public AnnotationVisitor visitArray(String name) {
                    if (name.equals("dependencies")) {
                        Visitor.this.nested = true;
                        return this;
                    }
                    return super.visitArray(name);
                }

                public void visitEnd() {
                    if (Visitor.this.nested) {
                        Visitor.this.nested = false;
                        return;
                    }
                    PluginLoader.this.candidates.add(new Candidate(Visitor.this.source, Visitor.this.className, Visitor.this.id, Visitor.this.version, Visitor.this.dependencies));
                    LOGGER.debug("Queued plugin candidate '{}' for loading", (Object)Visitor.this.id);
                }
            };
        }
    }

    private static enum State {
        FIND,
        CONSTRUCT,
        ENABLE,
        ACTIVE;

    }
}

