/*
 * Decompiled with CFR 0.152.
 */
package net.kyori.text.adapter.bukkit;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import net.kyori.text.Component;
import net.kyori.text.adapter.bukkit.Adapter;
import net.kyori.text.adapter.bukkit.CraftBukkitAdapter;
import net.kyori.text.adapter.bukkit.LegacyAdapter;
import net.kyori.text.adapter.bukkit.SpigotAdapter;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

final class TextAdapter0 {
    private static final List<Adapter> ADAPTERS = TextAdapter0.pickAdapters();

    TextAdapter0() {
    }

    private static List<Adapter> pickAdapters() {
        ImmutableList.Builder adapters = ImmutableList.builder();
        if (TextAdapter0.isSpigotAdapterSupported()) {
            adapters.add((Object)new SpigotAdapter());
        }
        adapters.add((Object)new CraftBukkitAdapter());
        adapters.add((Object)new LegacyAdapter());
        return adapters.build();
    }

    private static boolean isSpigotAdapterSupported() {
        try {
            Player.class.getMethod("spigot", new Class[0]);
            return true;
        }
        catch (NoSuchMethodException e) {
            return false;
        }
    }

    static void sendComponent(Iterable<? extends CommandSender> viewers, Component component, boolean actionBar) {
        LinkedList list = new LinkedList();
        Iterables.addAll(list, viewers);
        Iterator<Adapter> it = ADAPTERS.iterator();
        while (it.hasNext() && !list.isEmpty()) {
            Adapter adapter = it.next();
            adapter.sendComponent(list, component, actionBar);
        }
    }
}

