/*
 * Decompiled with CFR 0.152.
 */
package net.kyori.text;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.kyori.text.AbstractComponent;
import net.kyori.text.AbstractComponentBuilder;
import net.kyori.text.Component;
import net.kyori.text.KeybindComponent;
import net.kyori.text.format.Style;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

class KeybindComponentImpl
extends AbstractComponent
implements KeybindComponent {
    private final String keybind;

    protected KeybindComponentImpl(@NonNull List<Component> children, @NonNull Style style, @NonNull String keybind) {
        super(children, style);
        this.keybind = keybind;
    }

    @Override
    public @NonNull String keybind() {
        return this.keybind;
    }

    @Override
    public @NonNull KeybindComponent keybind(@NonNull String keybind) {
        return new KeybindComponentImpl(this.children, this.style, Objects.requireNonNull(keybind, "keybind"));
    }

    @Override
    public @NonNull KeybindComponent children(@NonNull List<Component> children) {
        return new KeybindComponentImpl(children, this.style, this.keybind);
    }

    @Override
    public @NonNull KeybindComponent style(@NonNull Style style) {
        return new KeybindComponentImpl(this.children, style, this.keybind);
    }

    @Override
    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof KeybindComponent)) {
            return false;
        }
        if (!super.equals(other)) {
            return false;
        }
        KeybindComponent component = (KeybindComponent)other;
        return Objects.equals(this.keybind, component.keybind());
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.keybind);
    }

    @Override
    protected void populateToString(@NonNull Map<String, Object> builder) {
        builder.put("keybind", this.keybind);
    }

    @Override
    public @NonNull KeybindComponent.Builder toBuilder() {
        return new BuilderImpl(this);
    }

    static class BuilderImpl
    extends AbstractComponentBuilder<KeybindComponent, KeybindComponent.Builder>
    implements KeybindComponent.Builder {
        private @Nullable String keybind;

        BuilderImpl() {
        }

        BuilderImpl(@NonNull KeybindComponent component) {
            super(component);
            this.keybind = component.keybind();
        }

        @Override
        public @NonNull KeybindComponent.Builder keybind(@NonNull String keybind) {
            this.keybind = keybind;
            return this;
        }

        @Override
        public @NonNull KeybindComponent build() {
            if (this.keybind == null) {
                throw new IllegalStateException("keybind must be set");
            }
            return new KeybindComponentImpl(this.children, this.buildStyle(), this.keybind);
        }
    }
}

