/*
 * Decompiled with CFR 0.152.
 */
package net.kyori.text;

import java.util.ArrayList;
import java.util.List;
import net.kyori.text.Component;
import net.kyori.text.ComponentBuilder;
import net.kyori.text.event.ClickEvent;
import net.kyori.text.event.HoverEvent;
import net.kyori.text.format.TextColor;
import net.kyori.text.format.TextDecoration;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public interface ScopedComponent<C extends Component>
extends Component {
    public @NonNull C children(@NonNull List<Component> var1);

    default public @NonNull C append(@NonNull Component component) {
        this.detectCycle(component);
        List<Component> oldChildren = this.children();
        ArrayList<Component> newChildren = new ArrayList<Component>(oldChildren.size() + 1);
        newChildren.addAll(oldChildren);
        newChildren.add(component);
        return this.children(newChildren);
    }

    default public @NonNull C append(@NonNull ComponentBuilder<?, ?> builder) {
        return (C)Component.super.append(builder);
    }

    default public @NonNull C color(@Nullable TextColor color) {
        return (C)Component.super.color(color);
    }

    default public @NonNull C decoration(@NonNull TextDecoration decoration, boolean flag) {
        return (C)Component.super.decoration(decoration, flag);
    }

    default public @NonNull C decoration(@NonNull TextDecoration decoration, @NonNull TextDecoration.State state) {
        return (C)Component.super.decoration(decoration, state);
    }

    default public @NonNull C clickEvent(@Nullable ClickEvent event) {
        return (C)Component.super.clickEvent(event);
    }

    default public @NonNull C hoverEvent(@Nullable HoverEvent event) {
        return (C)Component.super.hoverEvent(event);
    }

    default public @NonNull C insertion(@Nullable String insertion) {
        return (C)Component.super.insertion(insertion);
    }

    default public @NonNull C mergeColor(@NonNull Component that) {
        return (C)Component.super.mergeColor(that);
    }

    default public @NonNull C mergeDecorations(@NonNull Component that) {
        return (C)Component.super.mergeDecorations(that);
    }

    default public @NonNull C mergeEvents(@NonNull Component that) {
        return (C)Component.super.mergeEvents(that);
    }
}

