/*
 * This file is part of text, licensed under the MIT License.
 *
 * Copyright (c) 2017-2019 KyoriPowered
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */
package net.kyori.text.serializer;

import net.kyori.text.Component;
import net.kyori.text.event.ClickEvent;
import net.kyori.text.event.HoverEvent;

/**
 * A collection of component serializers.
 */
public final class ComponentSerializers {
  /**
   * A component serializer for JSON-based serialization and deserialization.
   */
  public static final ComponentSerializer<Component, Component, String> JSON = new GsonComponentSerializer();
  /**
   * A component serializer for legacy-based serialization and deserialization.
   *
   * <p>Legacy does <b>not</b> support more complex features such as, but not limited
   * to, {@link ClickEvent} and {@link HoverEvent}.</p>
   *
   * @deprecated legacy
   */
  @Deprecated
  public static final LegacyComponentSerializer LEGACY = new LegacyComponentSerializerImpl();
  /**
   * A component serializer for plain-based serialization and deserialization.
   *
   * <p>Plain does <b>not</b> support more complex features such as, but not limited
   * to, colours, decorations, {@link ClickEvent}, and {@link HoverEvent}.</p>
   *
   * @deprecated not recommended for general use
   */
  @Deprecated
  public static final PlainComponentSerializer PLAIN = new PlainComponentSerializer();

  private ComponentSerializers() {
  }
}
