/*
 * Decompiled with CFR 0.152.
 */
package net.kyori.text;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import net.kyori.text.AbstractBuildableComponent;
import net.kyori.text.Component;
import net.kyori.text.event.ClickEvent;
import net.kyori.text.event.HoverEvent;
import net.kyori.text.format.TextColor;
import net.kyori.text.format.TextDecoration;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class KeybindComponent
extends AbstractBuildableComponent<KeybindComponent, Builder> {
    private final @NonNull String keybind;

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(@NonNull String keybind) {
        return new Builder().keybind(keybind);
    }

    public static KeybindComponent of(@NonNull String keybind) {
        return KeybindComponent.builder(keybind).build();
    }

    public static KeybindComponent of(@NonNull String keybind, @Nullable TextColor color) {
        return KeybindComponent.of(keybind, color, Collections.emptySet());
    }

    public static KeybindComponent of(@NonNull String keybind, @Nullable TextColor color, @NonNull Set<TextDecoration> decorations) {
        return ((Builder)((Builder)KeybindComponent.builder(keybind).color(color)).decorations(decorations, true)).build();
    }

    public static KeybindComponent make(@NonNull Consumer<Builder> consumer) {
        Builder builder = KeybindComponent.builder();
        consumer.accept(builder);
        return builder.build();
    }

    public static KeybindComponent make(@NonNull String keybind, @NonNull Consumer<Builder> consumer) {
        Builder builder = KeybindComponent.builder(keybind);
        consumer.accept(builder);
        return builder.build();
    }

    protected KeybindComponent(@NonNull Builder builder) {
        super(builder);
        this.keybind = builder.keybind;
    }

    protected KeybindComponent(@NonNull List<Component> children, @Nullable TextColor color, @NonNull TextDecoration.State obfuscated, @NonNull TextDecoration.State bold, @NonNull TextDecoration.State strikethrough, @NonNull TextDecoration.State underlined, @NonNull TextDecoration.State italic, @Nullable ClickEvent clickEvent, @Nullable HoverEvent hoverEvent, @Nullable String insertion, @NonNull String keybind) {
        super(children, color, obfuscated, bold, strikethrough, underlined, italic, clickEvent, hoverEvent, insertion);
        this.keybind = keybind;
    }

    public @NonNull String keybind() {
        return this.keybind;
    }

    public @NonNull KeybindComponent keybind(@NonNull String keybind) {
        return new KeybindComponent(this.children, this.color, this.obfuscated, this.bold, this.strikethrough, this.underlined, this.italic, this.clickEvent, this.hoverEvent, this.insertion, (String)Preconditions.checkNotNull((Object)keybind, (Object)"keybind"));
    }

    @Override
    public @NonNull KeybindComponent append(@NonNull Component component) {
        this.detectCycle(component);
        ArrayList<Component> children = new ArrayList<Component>(this.children.size() + 1);
        children.addAll(this.children);
        children.add(component);
        return new KeybindComponent(children, this.color, this.obfuscated, this.bold, this.strikethrough, this.underlined, this.italic, this.clickEvent, this.hoverEvent, this.insertion, this.keybind);
    }

    @Override
    public @NonNull KeybindComponent color(@Nullable TextColor color) {
        return new KeybindComponent(this.children, color, this.obfuscated, this.bold, this.strikethrough, this.underlined, this.italic, this.clickEvent, this.hoverEvent, this.insertion, this.keybind);
    }

    @Override
    public @NonNull KeybindComponent decoration(@NonNull TextDecoration decoration, boolean flag) {
        return (KeybindComponent)super.decoration(decoration, flag);
    }

    @Override
    public @NonNull KeybindComponent decoration(@NonNull TextDecoration decoration, @NonNull TextDecoration.State state) {
        switch (decoration) {
            case BOLD: {
                return new KeybindComponent(this.children, this.color, this.obfuscated, (TextDecoration.State)((Object)Preconditions.checkNotNull((Object)((Object)state), (Object)"flag")), this.strikethrough, this.underlined, this.italic, this.clickEvent, this.hoverEvent, this.insertion, this.keybind);
            }
            case ITALIC: {
                return new KeybindComponent(this.children, this.color, this.obfuscated, this.bold, this.strikethrough, this.underlined, (TextDecoration.State)((Object)Preconditions.checkNotNull((Object)((Object)state), (Object)"flag")), this.clickEvent, this.hoverEvent, this.insertion, this.keybind);
            }
            case UNDERLINE: {
                return new KeybindComponent(this.children, this.color, this.obfuscated, this.bold, this.strikethrough, (TextDecoration.State)((Object)Preconditions.checkNotNull((Object)((Object)state), (Object)"flag")), this.italic, this.clickEvent, this.hoverEvent, this.insertion, this.keybind);
            }
            case STRIKETHROUGH: {
                return new KeybindComponent(this.children, this.color, this.obfuscated, this.bold, (TextDecoration.State)((Object)Preconditions.checkNotNull((Object)((Object)state), (Object)"flag")), this.underlined, this.italic, this.clickEvent, this.hoverEvent, this.insertion, this.keybind);
            }
            case OBFUSCATED: {
                return new KeybindComponent(this.children, this.color, (TextDecoration.State)((Object)Preconditions.checkNotNull((Object)((Object)state), (Object)"flag")), this.bold, this.strikethrough, this.underlined, this.italic, this.clickEvent, this.hoverEvent, this.insertion, this.keybind);
            }
        }
        throw new IllegalArgumentException(String.format("unknown decoration '%s'", decoration));
    }

    @Override
    public @NonNull KeybindComponent clickEvent(@Nullable ClickEvent event) {
        return new KeybindComponent(this.children, this.color, this.obfuscated, this.bold, this.strikethrough, this.underlined, this.italic, event, this.hoverEvent, this.insertion, this.keybind);
    }

    @Override
    public @NonNull KeybindComponent hoverEvent(@Nullable HoverEvent event) {
        if (event != null) {
            this.detectCycle(event.value());
        }
        return new KeybindComponent(this.children, this.color, this.obfuscated, this.bold, this.strikethrough, this.underlined, this.italic, this.clickEvent, event, this.insertion, this.keybind);
    }

    @Override
    public @NonNull KeybindComponent insertion(@Nullable String insertion) {
        return new KeybindComponent(this.children, this.color, this.obfuscated, this.bold, this.strikethrough, this.underlined, this.italic, this.clickEvent, this.hoverEvent, insertion, this.keybind);
    }

    @Override
    public @NonNull KeybindComponent mergeStyle(@NonNull Component that) {
        return new KeybindComponent(this.children, that.color(), that.decoration(TextDecoration.OBFUSCATED), that.decoration(TextDecoration.BOLD), that.decoration(TextDecoration.STRIKETHROUGH), that.decoration(TextDecoration.UNDERLINE), that.decoration(TextDecoration.ITALIC), that.clickEvent(), that.hoverEvent(), that.insertion(), this.keybind);
    }

    @Override
    public @NonNull KeybindComponent mergeColor(@NonNull Component that) {
        return new KeybindComponent(this.children, that.color(), this.obfuscated, this.bold, this.strikethrough, this.underlined, this.italic, this.clickEvent, this.hoverEvent, this.insertion, this.keybind);
    }

    @Override
    public @NonNull KeybindComponent mergeDecorations(@NonNull Component that) {
        TextDecoration.State obfuscated = that.decoration(TextDecoration.OBFUSCATED) != TextDecoration.State.NOT_SET ? that.decoration(TextDecoration.OBFUSCATED) : this.obfuscated;
        TextDecoration.State bold = that.decoration(TextDecoration.BOLD) != TextDecoration.State.NOT_SET ? that.decoration(TextDecoration.BOLD) : this.bold;
        TextDecoration.State strikethrough = that.decoration(TextDecoration.STRIKETHROUGH) != TextDecoration.State.NOT_SET ? that.decoration(TextDecoration.STRIKETHROUGH) : this.strikethrough;
        TextDecoration.State underlined = that.decoration(TextDecoration.UNDERLINE) != TextDecoration.State.NOT_SET ? that.decoration(TextDecoration.UNDERLINE) : this.underlined;
        TextDecoration.State italic = that.decoration(TextDecoration.ITALIC) != TextDecoration.State.NOT_SET ? that.decoration(TextDecoration.ITALIC) : this.italic;
        return new KeybindComponent(this.children, this.color, obfuscated, bold, strikethrough, underlined, italic, this.clickEvent, this.hoverEvent, this.insertion, this.keybind);
    }

    @Override
    public @NonNull KeybindComponent mergeEvents(@NonNull Component that) {
        return new KeybindComponent(this.children, this.color, this.obfuscated, this.bold, this.strikethrough, this.underlined, this.italic, that.clickEvent(), that.hoverEvent(), this.insertion, this.keybind);
    }

    @Override
    public @NonNull KeybindComponent resetStyle() {
        return new KeybindComponent(this.children, null, TextDecoration.State.NOT_SET, TextDecoration.State.NOT_SET, TextDecoration.State.NOT_SET, TextDecoration.State.NOT_SET, TextDecoration.State.NOT_SET, null, null, null, this.keybind);
    }

    @Override
    public @NonNull KeybindComponent copy() {
        return new KeybindComponent(this.children, this.color, this.obfuscated, this.bold, this.strikethrough, this.underlined, this.italic, this.clickEvent, this.hoverEvent, this.insertion, this.keybind);
    }

    @Override
    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || !(other instanceof KeybindComponent)) {
            return false;
        }
        if (!super.equals(other)) {
            return false;
        }
        KeybindComponent component = (KeybindComponent)other;
        return Objects.equals(this.keybind, component.keybind);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.keybind);
    }

    @Override
    protected void populateToString(// Could not load outer class - annotation placement on inner may be incorrect
     @NonNull MoreObjects.ToStringHelper builder) {
        builder.add("keybind", (Object)this.keybind);
    }

    @Override
    public @NonNull Builder toBuilder() {
        return new Builder(this);
    }

    public static class Builder
    extends AbstractBuildableComponent.AbstractBuilder<KeybindComponent, Builder> {
        private @Nullable String keybind;

        Builder() {
        }

        Builder(@NonNull KeybindComponent component) {
            super(component);
            this.keybind = component.keybind();
        }

        public @NonNull Builder keybind(@NonNull String keybind) {
            this.keybind = keybind;
            return this;
        }

        @Override
        public @NonNull KeybindComponent build() {
            Preconditions.checkState((this.keybind != null ? 1 : 0) != 0, (Object)"keybind must be set");
            return new KeybindComponent(this);
        }
    }
}

