/*
 * Decompiled with CFR 0.152.
 */
package net.kyori.text.event;

import com.google.common.base.Enums;
import com.google.common.base.MoreObjects;
import com.google.gson.annotations.SerializedName;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.NonNull;

public final class ClickEvent {
    private final @NonNull Action action;
    private final @NonNull String value;

    public ClickEvent(@NonNull Action action, @NonNull String value) {
        this.action = action;
        this.value = value;
    }

    public @NonNull Action action() {
        return this.action;
    }

    public @NonNull String value() {
        return this.value;
    }

    public @NonNull ClickEvent copy() {
        return new ClickEvent(this.action, this.value);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        ClickEvent that = (ClickEvent)other;
        return this.action == that.action && Objects.equals(this.value, that.value);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.action, this.value});
    }

    public @NonNull String toString() {
        return MoreObjects.toStringHelper((Object)this).add("action", (Object)this.action).add("value", (Object)this.value).toString();
    }

    public static enum Action {
        OPEN_URL(true),
        OPEN_FILE(false),
        RUN_COMMAND(true),
        SUGGEST_COMMAND(true),
        CHANGE_PAGE(true);

        private final @NonNull String toString = Enums.getField((Enum)this).getAnnotation(SerializedName.class).value();
        private final boolean readable;

        private Action(boolean readable) {
            this.readable = readable;
        }

        public boolean readable() {
            return this.readable;
        }

        public boolean isReadable() {
            return this.readable;
        }

        public @NonNull String toString() {
            return this.toString;
        }
    }
}

