/*
 * Decompiled with CFR 0.152.
 */
package net.kyori.text.event;

import com.google.common.base.Enums;
import com.google.common.base.MoreObjects;
import com.google.gson.annotations.SerializedName;
import java.util.Objects;
import net.kyori.text.Component;
import org.checkerframework.checker.nullness.qual.NonNull;

public final class HoverEvent {
    private final @NonNull Action action;
    private final @NonNull Component value;

    public HoverEvent(@NonNull Action action, @NonNull Component value) {
        this.action = action;
        this.value = value;
    }

    public @NonNull Action action() {
        return this.action;
    }

    public @NonNull Component value() {
        return this.value;
    }

    public @NonNull HoverEvent copy() {
        return new HoverEvent(this.action, this.value.copy());
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        HoverEvent that = (HoverEvent)other;
        return this.action == that.action && Objects.equals(this.value, that.value);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.action, this.value});
    }

    public @NonNull String toString() {
        return MoreObjects.toStringHelper((Object)this).add("action", (Object)this.action).add("value", (Object)this.value).toString();
    }

    public static enum Action {
        SHOW_TEXT(true),
        SHOW_ITEM(true),
        SHOW_ENTITY(true);

        private final @NonNull String toString = Enums.getField((Enum)this).getAnnotation(SerializedName.class).value();
        private final boolean readable;

        private Action(boolean readable) {
            this.readable = readable;
        }

        public boolean readable() {
            return this.readable;
        }

        @Deprecated
        public boolean isReadable() {
            return this.readable;
        }

        public @NonNull String toString() {
            return this.toString;
        }
    }
}

