/*
 * Decompiled with CFR 0.152.
 */
package net.kyori.xml.document.factory;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import net.kyori.xml.XMLException;
import net.kyori.xml.document.factory.DocumentFactory;
import net.kyori.xml.document.factory.DocumentFactoryBuilderImpl;
import net.kyori.xml.node.Node;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.input.SAXBuilder;

final class DocumentFactoryImpl
implements DocumentFactory {
    private final SAXBuilder builder;
    private final List<Path> includePaths;

    DocumentFactoryImpl(@NonNull DocumentFactoryBuilderImpl builder) {
        this.builder = builder.builder;
        this.includePaths = builder.includePaths;
    }

    @Override
    public @NonNull Document read(@NonNull Path path) throws XMLException {
        Document document = this.build(path);
        if (!this.includePaths.isEmpty()) {
            PreProcessor pp = new PreProcessor(path);
            pp.processChildren(document.getRootElement());
        }
        return document;
    }

    private @NonNull Document build(@NonNull Path path) throws XMLException {
        try {
            return this.builder.build(path.toFile());
        }
        catch (IOException e) {
            throw new XMLException("Encountered an exception while reading", e);
        }
        catch (JDOMException e) {
            throw new XMLException("Encountered an exception while parsing", e);
        }
    }

    final class PreProcessor {
        private final Path path;

        PreProcessor(Path path) {
            this.path = path;
        }

        void processChildren(Element parent) throws XMLException {
            for (int i = 0; i < parent.getContentSize(); ++i) {
                Content content = parent.getContent(i);
                if (!(content instanceof Element)) continue;
                Element child = (Element)content;
                if (this.processChild(i, parent, child)) {
                    --i;
                    continue;
                }
                this.processChildren(child);
            }
        }

        private boolean processChild(int index, Element parent, Element child) throws XMLException {
            if (child.getName().equals("include")) {
                parent.setContent(index, this.readInclude(child));
                return true;
            }
            return false;
        }

        private List<Content> readInclude(Element element) throws XMLException {
            Path src = Paths.get(Node.of(element).requireAttribute("src").value(), new String[0]);
            return this.readInclude(src, element);
        }

        private List<Content> readInclude(Path src, Element include) throws XMLException {
            Path path = this.findInclude(src);
            if (path == null) {
                throw new XMLException(Node.of(include), "Failed to find include: " + src);
            }
            return this.readDocument(path).getRootElement().cloneContent();
        }

        private Document readDocument(Path path) throws XMLException {
            Document document = DocumentFactoryImpl.this.build(path);
            this.processChildren(document.getRootElement());
            return document;
        }

        private @Nullable Path findInclude(Path include) {
            ArrayList<Path> includePaths = new ArrayList<Path>(DocumentFactoryImpl.this.includePaths);
            @Nullable Path basePath = this.path.getParent();
            if (basePath != null) {
                includePaths.add(0, basePath);
            }
            for (Path includePath : includePaths) {
                Path path = includePath.resolve(include);
                if (!Files.isRegularFile(path, new LinkOption[0])) continue;
                return path.toAbsolutePath();
            }
            return null;
        }
    }
}

