/*
 * Decompiled with CFR 0.152.
 */
package net.kyori.xml.node;

import java.util.Collection;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import net.kyori.lunar.EvenMoreObjects;
import net.kyori.xml.XMLException;
import net.kyori.xml.node.ElementNode;
import net.kyori.xml.node.Node;
import net.kyori.xml.node.stream.NodeStream;
import net.kyori.xml.node.stream.NodeStreamElement;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.jdom2.Element;

final class ElementNodeImpl
implements ElementNode {
    private final @NonNull Element element;

    ElementNodeImpl(@NonNull Element element) {
        this.element = element;
    }

    @Override
    public @NonNull Element element() {
        return this.element;
    }

    @Override
    public @NonNull NodeStreamElement<Node> attribute(final @NonNull String name) {
        final Optional<Node> node = Optional.ofNullable(this.element.getAttribute(name)).map(Node::of);
        return new NodeStreamElement<Node>(){

            @Override
            public @NonNull Optional<Node> optional() {
                return node;
            }

            @Override
            public @NonNull Node required() {
                XMLException exception = new XMLException(ElementNodeImpl.this, "missing required attribute '" + name + '\'');
                return this.optional().orElseThrow(() -> (NoSuchElementException)EvenMoreObjects.make((Object)new NoSuchElementException(exception.getMessage()), e -> e.initCause(exception)));
            }
        };
    }

    @Override
    public @NonNull NodeStream attributes() {
        return NodeStream.of(this.element.getAttributes().stream().map(Node::of));
    }

    @Override
    public @NonNull NodeStream attributes(@NonNull Collection<String> names) {
        return NodeStream.of(this.element.getAttributes().stream().filter(attribute -> names.contains(attribute.getName())).map(Node::of));
    }

    @Override
    public @NonNull NodeStream elements() {
        return NodeStream.of(this.element.getChildren().stream().map(Node::of));
    }

    @Override
    public @NonNull NodeStream elements(@NonNull Collection<String> names) {
        return NodeStream.of(this.element.getChildren().stream().filter(attribute -> names.contains(attribute.getName())).map(Node::of));
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        ElementNodeImpl that = (ElementNodeImpl)other;
        return Objects.equals(this.element, that.element);
    }

    public int hashCode() {
        return Objects.hash(this.element);
    }

    public String toString() {
        return "ElementNode{" + this.element.getName() + '}';
    }
}

