/*
 * Decompiled with CFR 0.152.
 */
package net.kyori.xml.node;

import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import net.kyori.xml.XMLException;
import net.kyori.xml.node.AttributeNode;
import net.kyori.xml.node.AttributeNodeImpl;
import net.kyori.xml.node.ElementNode;
import net.kyori.xml.node.ElementNodeImpl;
import net.kyori.xml.node.stream.NodeStream;
import net.kyori.xml.node.stream.NodeStreamElement;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.jdom2.Attribute;
import org.jdom2.Element;

public interface Node {
    public static @NonNull AttributeNode of(@NonNull Attribute attribute) {
        return new AttributeNodeImpl(attribute);
    }

    public static @NonNull Optional<AttributeNode> maybeOf(@Nullable Attribute attribute) {
        return attribute != null ? Optional.of(new AttributeNodeImpl(attribute)) : Optional.empty();
    }

    public static @NonNull ElementNode of(@NonNull Element element) {
        return new ElementNodeImpl(element);
    }

    public static @NonNull Optional<ElementNode> maybeOf(@Nullable Element element) {
        return element != null ? Optional.of(new ElementNodeImpl(element)) : Optional.empty();
    }

    public @NonNull String name();

    public @NonNull String value();

    public @NonNull String normalizedValue();

    default public @NonNull NodeStreamElement<Node> node(@NonNull String name) {
        return this.nodes(name).one();
    }

    default public @NonNull NodeStream nodes() {
        return NodeStream.concat(this.attributes(), this.elements());
    }

    default public @NonNull NodeStream nodes(@NonNull String name) {
        return this.nodes(Collections.singleton(name));
    }

    default public @NonNull NodeStream nodes(String ... names) {
        return this.nodes((Collection<String>)ImmutableSet.copyOf((Object[])names));
    }

    default public @NonNull NodeStream nodes(@NonNull Collection<String> names) {
        return NodeStream.concat(this.attributes(names), this.elements(names));
    }

    public @NonNull NodeStreamElement<Node> attribute(@NonNull String var1);

    default public @NonNull Node requireAttribute(@NonNull String name) throws XMLException {
        return this.attribute(name).optional().orElseThrow(() -> new XMLException(this, "missing required attribute '" + name + '\''));
    }

    public @NonNull NodeStream attributes();

    default public @NonNull NodeStream attributes(String ... names) {
        return this.attributes((Collection<String>)ImmutableSet.copyOf((Object[])names));
    }

    public @NonNull NodeStream attributes(@NonNull Collection<String> var1);

    default public @NonNull NodeStreamElement<Node> element(@NonNull String name) {
        return this.elements(name).one();
    }

    public @NonNull NodeStream elements();

    default public @NonNull NodeStream elements(@NonNull String name) {
        return this.elements(Collections.singleton(name));
    }

    default public @NonNull NodeStream elements(String ... names) {
        return this.elements((Collection<String>)ImmutableSet.copyOf((Object[])names));
    }

    public @NonNull NodeStream elements(@NonNull Collection<String> var1);
}

