/*
 * Decompiled with CFR 0.152.
 */
package net.kyori.xml.node.filter;

import com.google.common.collect.ImmutableSet;
import java.util.Collections;
import java.util.Set;
import net.kyori.xml.node.AttributeNode;
import net.kyori.xml.node.ElementNode;
import net.kyori.xml.node.filter.NodeFilter;
import org.checkerframework.checker.nullness.qual.NonNull;

public final class NodeFilters {
    private static final NodeFilter ALWAYS_FALSE = (node, depth) -> false;
    private static final NodeFilter ALWAYS_TRUE = (node, depth) -> true;
    private static final NodeFilter ONLY_ATTRIBUTES = (node, depth) -> node instanceof AttributeNode;
    private static final NodeFilter ONLY_ELEMENTS = (node, depth) -> node instanceof ElementNode;

    private NodeFilters() {
    }

    public static @NonNull NodeFilter alwaysFalse() {
        return ALWAYS_FALSE;
    }

    public static @NonNull NodeFilter alwaysTrue() {
        return ALWAYS_TRUE;
    }

    public static @NonNull NodeFilter onlyAttributes() {
        return ONLY_ATTRIBUTES;
    }

    public static @NonNull NodeFilter onlyElements() {
        return ONLY_ELEMENTS;
    }

    public static @NonNull NodeFilter minimumDepth(int minimumDepth) {
        return (node, depth) -> depth >= minimumDepth;
    }

    public static @NonNull NodeFilter named(@NonNull String name) {
        return NodeFilters.named(Collections.singleton(name));
    }

    public static @NonNull NodeFilter named(String ... names) {
        return NodeFilters.named((Set<String>)ImmutableSet.copyOf((Object[])names));
    }

    public static @NonNull NodeFilter named(@NonNull Set<String> names) {
        return (node, depth) -> names.contains(node.name());
    }
}

