/*
 * Decompiled with CFR 0.152.
 */
package net.kyori.xml.node.flattener;

import java.util.Collections;
import java.util.Set;
import net.kyori.xml.node.Node;
import net.kyori.xml.node.filter.NodeFilter;
import net.kyori.xml.node.filter.NodeFilters;
import net.kyori.xml.node.flattener.NodeFlattener;
import net.kyori.xml.node.stream.NodeStream;
import org.checkerframework.checker.nullness.qual.NonNull;

public class BranchLeafNodeFlattener
extends NodeFlattener.Impl {
    private final @NonNull NodeFilter branchFilter;
    private final @NonNull NodeFilter leafFilter;

    public BranchLeafNodeFlattener(@NonNull String branch, @NonNull String leaf) {
        this(Collections.singleton(branch), Collections.singleton(leaf));
    }

    public BranchLeafNodeFlattener(@NonNull Set<String> branches, @NonNull Set<String> leafs) {
        this(NodeFilters.named(branches), NodeFilters.named(leafs));
    }

    public BranchLeafNodeFlattener(@NonNull NodeFilter branchFilter, @NonNull NodeFilter leafFilter) {
        this.branchFilter = branchFilter;
        this.leafFilter = leafFilter;
    }

    @Override
    public @NonNull NodeStream flatten(@NonNull Node node, int depth) {
        if (this.branchFilter.test(node, depth)) {
            return this.node(node, depth).nodes().flatMap(child -> this.flatten((Node)child, depth + 1));
        }
        if (this.leafFilter.test(node, depth)) {
            return NodeStream.of(this.node(node, depth));
        }
        return NodeStream.empty();
    }
}

