/*
 * Decompiled with CFR 0.152.
 */
package net.kyori.xml.node.flattener;

import java.util.Arrays;
import java.util.List;
import net.kyori.xml.node.Node;
import net.kyori.xml.node.filter.NodeFilter;
import net.kyori.xml.node.flattener.NodeFlattener;
import net.kyori.xml.node.stream.NodeStream;
import org.checkerframework.checker.nullness.qual.NonNull;

public class PathNodeFlattener
extends NodeFlattener.Impl {
    private final @NonNull NodeFilter filter;
    private final @NonNull List<String> path;

    public PathNodeFlattener(@NonNull NodeFilter filter, String ... path) {
        this(filter, Arrays.asList(path));
    }

    public PathNodeFlattener(@NonNull NodeFilter filter, @NonNull List<String> path) {
        this.filter = filter;
        this.path = path;
    }

    @Override
    public @NonNull NodeStream flatten(@NonNull Node node, int depth) {
        if (this.path.size() > depth && this.filter.test(node, depth)) {
            return node.nodes(this.path.get(depth)).flatMap(that -> this.flatten((Node)that, depth + 1));
        }
        return NodeStream.of(this.node(node, depth));
    }
}

