/*
 * Decompiled with CFR 0.152.
 */
package net.kyori.xml.node.parser;

import com.google.inject.TypeLiteral;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.inject.Inject;
import net.kyori.xml.XMLException;
import net.kyori.xml.node.Node;
import net.kyori.xml.node.parser.PrimitiveParser;
import org.checkerframework.checker.nullness.qual.NonNull;

public class EnumParser<E extends Enum<E>>
implements PrimitiveParser<E> {
    private final TypeLiteral<E> type;
    private final Map<String, E> map = new HashMap<String, E>();

    public EnumParser(@NonNull Class<E> type) {
        this(TypeLiteral.get(type));
    }

    @Inject
    public EnumParser(@NonNull TypeLiteral<E> type) {
        this.type = type;
        for (Enum constant : (Enum[])type.getRawType().getEnumConstants()) {
            this.map.put(constant.name().toLowerCase(Locale.ENGLISH), constant);
        }
    }

    @Override
    public @NonNull E throwingParse(@NonNull Node node, @NonNull String string) throws XMLException {
        Enum constant = (Enum)this.map.get(string.toLowerCase(Locale.ENGLISH).replace(' ', '_'));
        if (constant != null) {
            return (E)constant;
        }
        throw new XMLException(node, "Could not find " + this.type.getRawType().getName() + " with name '" + string + '\'');
    }
}

