/*
 * Decompiled with CFR 0.152.
 */
package net.kyori.xml.node.parser;

import com.google.common.collect.BoundType;
import com.google.common.collect.Range;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.inject.Inject;
import net.kyori.xml.XMLException;
import net.kyori.xml.node.Node;
import net.kyori.xml.node.parser.PrimitiveParser;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class RangeParser<C extends Comparable<C>>
implements PrimitiveParser<Range<C>> {
    private static final Pattern PATTERN = Pattern.compile("([(|\\[])((?:\\d+\\.?\\d*?|-\u221e|-oo))?(?:\\.{2}|\u2025)((?:\\d+\\.?\\d*?|\\+\u221e|\\+oo))?([)|\\]])");
    private final PrimitiveParser<C> parser;

    @Inject
    public RangeParser(PrimitiveParser<C> parser) {
        this.parser = parser;
    }

    @Override
    public @NonNull Range<C> throwingParse(@NonNull Node node, @NonNull String string) throws XMLException {
        Matcher matcher = PATTERN.matcher(string);
        if (!matcher.matches()) {
            Comparable single = (Comparable)this.parser.throwingParse(node, string);
            if (single != null) {
                return Range.singleton((Comparable)single);
            }
            throw new XMLException(node, "Could not parse '" + string + "' as a range");
        }
        BoundType lowerType = RangeParser.boundType(matcher.group(1));
        C lower = this.parse(node, matcher.group(2));
        C upper = this.parse(node, matcher.group(3));
        BoundType upperType = RangeParser.boundType(matcher.group(4));
        if (lower == null) {
            if (upper == null) {
                return Range.all();
            }
            return Range.upTo(upper, (BoundType)upperType);
        }
        if (upper == null) {
            return Range.downTo(lower, (BoundType)lowerType);
        }
        return Range.range(lower, (BoundType)lowerType, upper, (BoundType)upperType);
    }

    private @Nullable C parse(Node node, String string) throws XMLException {
        switch (string) {
            case "-\u221e": 
            case "-oo": {
                return null;
            }
            default: {
                return (C)((Comparable)this.parser.throwingParse(node, string));
            }
            case "+\u221e": 
            case "+oo": 
        }
        return null;
    }

    private static BoundType boundType(String string) {
        if ("(".equals(string) || ")".equals(string)) {
            return BoundType.OPEN;
        }
        return BoundType.CLOSED;
    }
}

