/*
 * Decompiled with CFR 0.152.
 */
package net.kyori.xml.node.parser.number;

import javax.inject.Singleton;
import net.kyori.xml.XMLException;
import net.kyori.xml.node.Node;
import net.kyori.xml.node.parser.number.NumberParser;
import org.checkerframework.checker.nullness.qual.NonNull;

@Singleton
public class ByteParser
implements NumberParser<Byte> {
    @Override
    public @NonNull Byte negativeInfinity(@NonNull Node node, @NonNull String string) {
        return (byte)-128;
    }

    @Override
    public @NonNull Byte finite(@NonNull Node node, @NonNull String string) throws XMLException {
        try {
            return Byte.parseByte(string);
        }
        catch (NumberFormatException e) {
            throw new XMLException(node, "Could not parse '" + string + "' as a byte", e);
        }
    }

    @Override
    public @NonNull Byte positiveInfinity(@NonNull Node node, @NonNull String string) {
        return (byte)127;
    }
}

