/*
 * Decompiled with CFR 0.152.
 */
package net.kyori.xml.node.parser.number;

import javax.inject.Singleton;
import net.kyori.xml.XMLException;
import net.kyori.xml.node.Node;
import net.kyori.xml.node.parser.number.NumberParser;
import org.checkerframework.checker.nullness.qual.NonNull;

@Singleton
public class DoubleParser
implements NumberParser<Double> {
    @Override
    public @NonNull Double negativeInfinity(@NonNull Node node, @NonNull String string) {
        return Double.NEGATIVE_INFINITY;
    }

    @Override
    public @NonNull Double finite(@NonNull Node node, @NonNull String string) throws XMLException {
        try {
            return Double.parseDouble(string);
        }
        catch (NumberFormatException e) {
            throw new XMLException(node, "Could not parse '" + string + "' as a double", e);
        }
    }

    @Override
    public @NonNull Double positiveInfinity(@NonNull Node node, @NonNull String string) {
        return Double.POSITIVE_INFINITY;
    }
}

