/*
 * Decompiled with CFR 0.152.
 */
package net.kyori.xml.node.parser.number;

import javax.inject.Singleton;
import net.kyori.xml.XMLException;
import net.kyori.xml.node.Node;
import net.kyori.xml.node.parser.number.NumberParser;
import org.checkerframework.checker.nullness.qual.NonNull;

@Singleton
public class FloatParser
implements NumberParser<Float> {
    @Override
    public @NonNull Float negativeInfinity(@NonNull Node node, @NonNull String string) {
        return Float.valueOf(Float.NEGATIVE_INFINITY);
    }

    @Override
    public @NonNull Float finite(@NonNull Node node, @NonNull String string) throws XMLException {
        try {
            return Float.valueOf(Float.parseFloat(string));
        }
        catch (NumberFormatException e) {
            throw new XMLException(node, "Could not parse '" + string + "' as a float", e);
        }
    }

    @Override
    public @NonNull Float positiveInfinity(@NonNull Node node, @NonNull String string) {
        return Float.valueOf(Float.POSITIVE_INFINITY);
    }
}

