/*
 * Decompiled with CFR 0.152.
 */
package net.kyori.xml.node.parser.number;

import javax.inject.Singleton;
import net.kyori.xml.XMLException;
import net.kyori.xml.node.Node;
import net.kyori.xml.node.parser.number.NumberParser;
import org.checkerframework.checker.nullness.qual.NonNull;

@Singleton
public class IntegerParser
implements NumberParser<Integer> {
    @Override
    public @NonNull Integer negativeInfinity(@NonNull Node node, @NonNull String string) {
        return Integer.MIN_VALUE;
    }

    @Override
    public @NonNull Integer finite(@NonNull Node node, @NonNull String string) throws XMLException {
        try {
            return Integer.parseInt(string);
        }
        catch (NumberFormatException e) {
            throw new XMLException(node, "Could not parse '" + string + "' as an int", e);
        }
    }

    @Override
    public @NonNull Integer positiveInfinity(@NonNull Node node, @NonNull String string) {
        return Integer.MAX_VALUE;
    }
}

