/*
 * Decompiled with CFR 0.152.
 */
package net.kyori.xml.node.parser.number;

import javax.inject.Singleton;
import net.kyori.xml.XMLException;
import net.kyori.xml.node.Node;
import net.kyori.xml.node.parser.number.NumberParser;
import org.checkerframework.checker.nullness.qual.NonNull;

@Singleton
public class LongParser
implements NumberParser<Long> {
    @Override
    public @NonNull Long negativeInfinity(@NonNull Node node, @NonNull String string) {
        return Long.MIN_VALUE;
    }

    @Override
    public @NonNull Long finite(@NonNull Node node, @NonNull String string) throws XMLException {
        try {
            return Long.parseLong(string);
        }
        catch (NumberFormatException e) {
            throw new XMLException(node, "Could not parse '" + string + "' as a long", e);
        }
    }

    @Override
    public @NonNull Long positiveInfinity(@NonNull Node node, @NonNull String string) {
        return Long.MAX_VALUE;
    }
}

