/*
 * Decompiled with CFR 0.152.
 */
package net.kyori.xml.node.parser.number;

import net.kyori.xml.XMLException;
import net.kyori.xml.node.Node;
import net.kyori.xml.node.parser.PrimitiveParser;
import org.checkerframework.checker.nullness.qual.NonNull;

public interface NumberParser<T extends Number>
extends PrimitiveParser<T> {
    public static final String INFINITY_SYMBOL_A = "\u221e";
    public static final String INFINITY_SYMBOL_B = "oo";
    public static final String NEGATIVE_INFINITY_SYMBOL_A = "-\u221e";
    public static final String NEGATIVE_INFINITY_SYMBOL_B = "-oo";
    public static final String POSITIVE_INFINITY_SYMBOL_A = "+\u221e";
    public static final String POSITIVE_INFINITY_SYMBOL_B = "+oo";

    @Override
    default public @NonNull T throwingParse(@NonNull Node node, @NonNull String string) throws XMLException {
        switch (string) {
            case "-\u221e": 
            case "-oo": {
                return this.negativeInfinity(node, string);
            }
            default: {
                return this.finite(node, string);
            }
            case "+\u221e": 
            case "+oo": 
        }
        return this.positiveInfinity(node, string);
    }

    public @NonNull T negativeInfinity(@NonNull Node var1, @NonNull String var2) throws XMLException;

    public @NonNull T finite(@NonNull Node var1, @NonNull String var2) throws XMLException;

    public @NonNull T positiveInfinity(@NonNull Node var1, @NonNull String var2) throws XMLException;
}

