/*
 * Decompiled with CFR 0.152.
 */
package net.kyori.xml.node.parser.number;

import javax.inject.Singleton;
import net.kyori.xml.XMLException;
import net.kyori.xml.node.Node;
import net.kyori.xml.node.parser.number.NumberParser;
import org.checkerframework.checker.nullness.qual.NonNull;

@Singleton
public class ShortParser
implements NumberParser<Short> {
    @Override
    public @NonNull Short negativeInfinity(@NonNull Node node, @NonNull String string) {
        return (short)Short.MIN_VALUE;
    }

    @Override
    public @NonNull Short finite(@NonNull Node node, @NonNull String string) throws XMLException {
        try {
            return Short.parseShort(string);
        }
        catch (NumberFormatException e) {
            throw new XMLException(node, "Could not parse '" + string + "' as a short", e);
        }
    }

    @Override
    public @NonNull Short positiveInfinity(@NonNull Node node, @NonNull String string) {
        return (short)Short.MAX_VALUE;
    }
}

