/*
 * Decompiled with CFR 0.152.
 */
package net.kyori.xml.node.stream;

import com.google.common.collect.MoreCollectors;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collector;
import java.util.stream.Stream;
import net.kyori.lunar.CheckedAutoCloseable;
import net.kyori.xml.node.Node;
import net.kyori.xml.node.stream.NodeStreamElement;
import net.kyori.xml.node.stream.NodeStreamImpl;
import org.checkerframework.checker.nullness.qual.NonNull;

public interface NodeStream
extends CheckedAutoCloseable {
    public static @NonNull NodeStream empty() {
        return NodeStream.of(Stream.empty());
    }

    public static @NonNull NodeStream of(@NonNull Node node) {
        return NodeStream.of(Stream.of(node));
    }

    public static @NonNull NodeStream of(@NonNull Stream<Node> stream) {
        return new NodeStreamImpl(stream);
    }

    public static @NonNull NodeStream concat(@NonNull NodeStream a, @NonNull NodeStream b) {
        return NodeStream.of(Stream.concat(a.stream(), b.stream()));
    }

    public @NonNull Stream<Node> stream();

    public @NonNull NodeStream filter(@NonNull Predicate<? super Node> var1);

    default public @NonNull NodeStream named(@NonNull String name) {
        return this.named(Collections.singleton(name));
    }

    default public @NonNull NodeStream named(String ... names) {
        return this.named(Sets.newHashSet((Object[])names));
    }

    default public @NonNull NodeStream named(@NonNull Collection<String> names) {
        return this.filter(node -> names.contains(node.name()));
    }

    default public <R> Stream<R> map(Function<? super Node, ? extends R> mapper) {
        return this.stream().map(mapper);
    }

    public @NonNull NodeStream flatMap(@NonNull Function<? super Node, ? extends NodeStream> var1);

    default public void forEach(@NonNull Consumer<? super Node> action) {
        this.stream().forEach(action);
    }

    default public <R, A> R collect(@NonNull Collector<? super Node, A, R> collector) {
        return this.stream().collect(collector);
    }

    default public @NonNull Optional<Node> findAny() {
        return this.stream().findAny();
    }

    default public @NonNull Optional<Node> findFirst() {
        return this.stream().findFirst();
    }

    default public @NonNull NodeStreamElement<Node> one() {
        Optional node = (Optional)this.collect(MoreCollectors.toOptional());
        return () -> node;
    }
}

