/*
 * Decompiled with CFR 0.152.
 */
package net.kyori.xml.node.stream;

import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import org.checkerframework.checker.nullness.qual.NonNull;

public interface NodeStreamElement<T> {
    public static final NodeStreamElement<Object> EMPTY = Optional::empty;

    public static <T> @NonNull NodeStreamElement<T> empty() {
        return EMPTY;
    }

    public @NonNull Optional<T> optional();

    default public T optional(T defaultValue) {
        return this.optional().orElse(defaultValue);
    }

    default public @NonNull T required() {
        return this.optional().orElseThrow(NoSuchElementException::new);
    }

    default public <R> @NonNull NodeStreamElement<R> map(@NonNull Function<? super T, ? extends R> mapper) {
        return () -> this.optional().map(mapper);
    }

    default public void ifPresent(Consumer<? super T> consumer) {
        this.optional().ifPresent(consumer);
    }
}

