/*
 * Decompiled with CFR 0.152.
 */
package net.lag.smile;

import java.rmi.RemoteException;
import net.lag.logging.Logger;
import net.lag.logging.Logger$;
import net.lag.smile.KeyTooLongException;
import net.lag.smile.MemcacheClient$;
import net.lag.smile.MemcacheClientError;
import net.lag.smile.MemcacheCodec;
import net.lag.smile.MemcacheConnection;
import net.lag.smile.MemcacheServerException;
import net.lag.smile.NodeLocator;
import net.lag.smile.ServerPool;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Iterable;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.ScalaObject;
import scala.Seq;
import scala.Some;
import scala.StringBuilder;
import scala.Tuple2;
import scala.collection.immutable.Map;
import scala.collection.mutable.HashMap;
import scala.runtime.BoxedArray;
import scala.runtime.BoxedObjectArray;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MemcacheClient<T>
implements ScalaObject {
    private final int MAX_KEY_SIZE;
    private Option<String> namespace;
    private ServerPool pool;
    private final Logger net$lag$smile$MemcacheClient$$log;
    public final MemcacheCodec net$lag$smile$MemcacheClient$$codec;
    private final NodeLocator locator;

    public MemcacheClient(NodeLocator locator, MemcacheCodec<T> codec) {
        this.locator = locator;
        this.net$lag$smile$MemcacheClient$$codec = codec;
        this.net$lag$smile$MemcacheClient$$log = Logger$.MODULE$.get(this.getClass().getName());
        this.pool = null;
        this.namespace = None$.MODULE$;
        this.MAX_KEY_SIZE = 250;
    }

    private void checkForEject() {
        this.pool().scanForEjections();
        this.locator.setPool(this.pool());
    }

    private void checkForUneject() {
        if (this.pool().shouldRecheckEjectedConnections()) {
            this.net$lag$smile$MemcacheClient$$log().info("Retrying ejections...", (Seq)new BoxedObjectArray(new Object[0]));
            this.locator.setPool(this.pool());
        }
    }

    public final Object net$lag$smile$MemcacheClient$$withNode(MemcacheConnection node, Function0 f) {
        Object exceptionResult1 = null;
        try {
            exceptionResult1 = f.apply();
            return exceptionResult1;
        }
        catch (MemcacheServerException memcacheServerException) {
            if (node.isEjected()) {
                this.net$lag$smile$MemcacheClient$$log().info("Ejecting from pool: %s", (Seq)new BoxedObjectArray(new Object[]{node}));
                this.checkForEject();
            }
            throw memcacheServerException;
        }
        catch (MemcacheClientError memcacheClientError) {
            throw memcacheClientError;
        }
    }

    private <T> T withNode(String key, Function2<MemcacheConnection, String, T> f$1) {
        this.checkForUneject();
        Tuple2<MemcacheConnection, String> tuple2 = this.nodeForKey(key);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Tuple2 tuple22 = new Tuple2(tuple2._1(), tuple2._2());
        MemcacheConnection node$2 = (MemcacheConnection)tuple22._1();
        String realKey$1 = (String)tuple22._2();
        return (T)this.net$lag$smile$MemcacheClient$$withNode(node$2, new $anonfun$withNode$1(this, f$1, node$2, realKey$1));
    }

    public Tuple2<MemcacheConnection, String> nodeForKey(String key) {
        Option<String> option;
        block6: {
            String realKey;
            block5: {
                String string;
                block4: {
                    option = this.namespace();
                    None$ none$ = None$.MODULE$;
                    Option<String> option2 = option;
                    if (none$ != null ? !none$.equals(option2) : option2 != null) break block4;
                    string = key;
                    break block5;
                }
                if (!(option instanceof Some)) break block6;
                string = realKey = new StringBuilder().append((Object)((String)((Some)option).x())).append((Object)key).toString();
            }
            if (realKey.length() > this.MAX_KEY_SIZE()) {
                throw new KeyTooLongException();
            }
            return new Tuple2((Object)this.locator.findNode(realKey.getBytes("utf-8")), (Object)realKey);
        }
        throw new MatchError(option);
    }

    public String serverForKey(String key) {
        return (String)this.withNode(key, new $anonfun$serverForKey$1(this));
    }

    public Option<Long> decr(String key, long value$7) throws MemcacheServerException {
        return (Option)this.withNode(key, new $anonfun$decr$1(this, value$7));
    }

    public Option<Long> incr(String key, long value$6) throws MemcacheServerException {
        return (Option)this.withNode(key, new $anonfun$incr$1(this, value$6));
    }

    public boolean prepend(String key, T value) throws MemcacheServerException {
        return this.prependData(key, this.net$lag$smile$MemcacheClient$$codec.encode(value));
    }

    public boolean prependData(String key, byte[] value$5) throws MemcacheServerException {
        return BoxesRunTime.unboxToBoolean(this.withNode(key, new $anonfun$prependData$1(this, value$5)));
    }

    public boolean append(String key, T value) throws MemcacheServerException {
        return this.appendData(key, this.net$lag$smile$MemcacheClient$$codec.encode(value));
    }

    public boolean appendData(String key, byte[] value$4) throws MemcacheServerException {
        return BoxesRunTime.unboxToBoolean(this.withNode(key, new $anonfun$appendData$1(this, value$4)));
    }

    public <A> void replace(String key, A value, MemcacheCodec<A> codec) throws MemcacheServerException {
        this.replace(key, value, 0, 0, codec);
    }

    public <A> void replace(String key, A value, int flags, int expiry, MemcacheCodec<A> codec) throws MemcacheServerException {
        this.replaceData(key, codec.encode(value), flags, expiry);
    }

    public void replace(String key, T value) throws MemcacheServerException {
        this.replace(key, value, 0, 0);
    }

    public void replace(String key, T value, int flags, int expiry) throws MemcacheServerException {
        this.replaceData(key, this.net$lag$smile$MemcacheClient$$codec.encode(value), flags, expiry);
    }

    public void replaceData(String key, byte[] value) throws MemcacheServerException {
        this.replaceData(key, value, 0, 0);
    }

    public boolean replaceData(String key, byte[] value$3, int flags$3, int expiry$3) throws MemcacheServerException {
        return BoxesRunTime.unboxToBoolean(this.withNode(key, new $anonfun$replaceData$1(this, value$3, flags$3, expiry$3)));
    }

    public <A> boolean add(String key, A value, MemcacheCodec<A> codec) throws MemcacheServerException {
        return this.add(key, value, 0, 0, codec);
    }

    public <A> boolean add(String key, A value, int flags, int expiry, MemcacheCodec<A> codec) throws MemcacheServerException {
        return this.addData(key, codec.encode(value), flags, expiry);
    }

    public boolean add(String key, T value) throws MemcacheServerException {
        return this.add(key, value, 0, 0);
    }

    public boolean add(String key, T value, int flags, int expiry) throws MemcacheServerException {
        return this.addData(key, this.net$lag$smile$MemcacheClient$$codec.encode(value), flags, expiry);
    }

    public boolean addData(String key, byte[] value) throws MemcacheServerException {
        return this.addData(key, value, 0, 0);
    }

    public boolean addData(String key, byte[] value$2, int flags$2, int expiry$2) throws MemcacheServerException {
        return BoxesRunTime.unboxToBoolean(this.withNode(key, new $anonfun$addData$1(this, value$2, flags$2, expiry$2)));
    }

    public void delete(String key) throws MemcacheServerException {
        this.withNode(key, new $anonfun$delete$1(this));
    }

    public <A> boolean set(String key, A value, MemcacheCodec<A> codec) throws MemcacheServerException {
        return this.set(key, value, 0, 0, codec);
    }

    public <A> boolean set(String key, A value, int flags, int expiry, MemcacheCodec<A> codec) throws MemcacheServerException {
        return this.setData(key, codec.encode(value), flags, expiry);
    }

    public boolean set(String key, T value) throws MemcacheServerException {
        return this.set(key, value, 0, 0);
    }

    public boolean set(String key, T value, int flags, int expiry) throws MemcacheServerException {
        return this.setData(key, this.net$lag$smile$MemcacheClient$$codec.encode(value), flags, expiry);
    }

    public boolean setData(String key, byte[] value) throws MemcacheServerException {
        return this.setData(key, value, 0, 0);
    }

    public boolean setData(String key, byte[] value$1, int flags$1, int expiry$1) throws MemcacheServerException {
        return BoxesRunTime.unboxToBoolean(this.withNode(key, new $anonfun$setData$1(this, value$1, flags$1, expiry$1)));
    }

    public <A> Map<String, A> get(String[] keys, MemcacheCodec<A> codec$1) throws MemcacheServerException {
        return Predef$.MODULE$.Map().empty().$plus$plus(this.getData(keys).elements().map((Function1)new $anonfun$get$2(this, codec$1)));
    }

    public Map<String, T> get(String[] keys) throws MemcacheServerException {
        return Predef$.MODULE$.Map().empty().$plus$plus(this.getData(keys).elements().map((Function1)new $anonfun$get$1(this)));
    }

    public Map<String, byte[]> getData(String[] keys) throws MemcacheServerException {
        HashMap keyMap$1 = new HashMap();
        HashMap nodeKeys$1 = new HashMap();
        new BoxedObjectArray((Object[])keys).foreach((Function1)new $anonfun$getData$2(this, keyMap$1, nodeKeys$1));
        Iterable futures = nodeKeys$1.map((Function1)new $anonfun$1(this));
        return Predef$.MODULE$.Map().empty().$plus$plus(futures.flatMap((Function1)new $anonfun$getData$3(this, keyMap$1)));
    }

    public <A> Option<A> get(String key, MemcacheCodec<A> codec) throws MemcacheServerException {
        Option<byte[]> option;
        block4: {
            None$ none$;
            block3: {
                block2: {
                    option = this.getData(key);
                    None$ none$2 = None$.MODULE$;
                    Option<byte[]> option2 = option;
                    if (none$2 != null ? !none$2.equals(option2) : option2 != null) break block2;
                    none$ = None$.MODULE$;
                    break block3;
                }
                if (!(option instanceof Some)) break block4;
                Object object = ((Some)option).x();
                Object object2 = object instanceof BoxedArray ? ScalaRunTime$.MODULE$.arrayValue((BoxedArray)object, Byte.TYPE) : object;
                none$ = new Some(codec.decode((byte[])object2));
            }
            return none$;
        }
        throw new MatchError(option);
    }

    public Option<T> get(String key) throws MemcacheServerException {
        Option<byte[]> option;
        block4: {
            None$ none$;
            block3: {
                block2: {
                    option = this.getData(key);
                    None$ none$2 = None$.MODULE$;
                    Option<byte[]> option2 = option;
                    if (none$2 != null ? !none$2.equals(option2) : option2 != null) break block2;
                    none$ = None$.MODULE$;
                    break block3;
                }
                if (!(option instanceof Some)) break block4;
                Object object = ((Some)option).x();
                Object object2 = object instanceof BoxedArray ? ScalaRunTime$.MODULE$.arrayValue((BoxedArray)object, Byte.TYPE) : object;
                none$ = new Some(this.net$lag$smile$MemcacheClient$$codec.decode((byte[])object2));
            }
            return none$;
        }
        throw new MatchError(option);
    }

    public Option<byte[]> getData(String key) throws MemcacheServerException {
        return (Option)this.withNode(key, new $anonfun$getData$1(this));
    }

    public MemcacheConnection[] servers() {
        return this.pool().servers();
    }

    public String toString() {
        return Predef$.MODULE$.stringWrapper("<MemcacheClient locator=%s servers=%s>").format((Seq)new BoxedObjectArray(new Object[]{this.locator, this.pool()}));
    }

    public void shutdown() {
        this.pool().shutdown();
        this.pool_$eq(null);
    }

    public void setPool(ServerPool pool) {
        this.pool_$eq(pool);
        this.locator.setPool(pool);
    }

    public int MAX_KEY_SIZE() {
        return this.MAX_KEY_SIZE;
    }

    public void namespace_$eq(Option<String> x$1) {
        this.namespace = x$1;
    }

    public Option<String> namespace() {
        return this.namespace;
    }

    private void pool_$eq(ServerPool x$1) {
        this.pool = x$1;
    }

    private ServerPool pool() {
        return this.pool;
    }

    public final Logger net$lag$smile$MemcacheClient$$log() {
        return this.net$lag$smile$MemcacheClient$$log;
    }

    public int $tag() throws RemoteException {
        return ScalaObject.class.$tag((ScalaObject)this);
    }
}

