/*
 * Decompiled with CFR 0.152.
 */
package net.lag.smile;

import java.rmi.RemoteException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import net.lag.naggati.IoHandlerActorAdapter;
import net.lag.smile.LoggingFilter;
import net.lag.smile.MemcacheClientDecoder$;
import net.lag.smile.MemcacheConnection;
import net.lag.smile.ServerPool$;
import org.apache.mina.core.filterchain.IoFilter;
import org.apache.mina.core.service.IoHandler;
import org.apache.mina.core.service.IoProcessor;
import org.apache.mina.transport.socket.nio.NioProcessor;
import org.apache.mina.transport.socket.nio.NioSocketConnector;
import scala.Array$;
import scala.Function1;
import scala.Iterable;
import scala.Predef$;
import scala.ScalaObject;
import scala.Seq;
import scala.collection.mutable.ListBuffer;
import scala.runtime.BoxedArray;
import scala.runtime.BoxedObjectArray;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServerPool
implements ScalaObject {
    private NioSocketConnector connector;
    private int maxFailuresBeforeEjection;
    private int connectTimeout;
    private int readTimeout;
    private int retryDelay;
    private int DEFAULT_CONNECT_TIMEOUT;
    private final ListBuffer<MemcacheConnection> watchList;
    private MemcacheConnection[] servers;
    private ExecutorService threadPool = Executors.newCachedThreadPool();

    public ServerPool(boolean trace) {
        Object object = ScalaRunTime$.MODULE$.arrayValue(Array$.MODULE$.apply((Seq)new BoxedObjectArray((Object[])new MemcacheConnection[0])), MemcacheConnection.class);
        this.servers = (MemcacheConnection[])(object instanceof BoxedArray ? ScalaRunTime$.MODULE$.arrayValue((BoxedArray)object, MemcacheConnection.class) : object);
        this.watchList = new ListBuffer();
        this.DEFAULT_CONNECT_TIMEOUT = 250;
        this.retryDelay = 30000;
        this.readTimeout = 2000;
        this.connectTimeout = this.DEFAULT_CONNECT_TIMEOUT();
        this.maxFailuresBeforeEjection = 3;
        this.connector = new NioSocketConnector((IoProcessor)new NioProcessor((Executor)this.threadPool()));
        this.connector().setConnectTimeoutMillis(Predef$.MODULE$.int2long(this.connectTimeout()));
        this.connector().getSessionConfig().setTcpNoDelay(true);
        if (trace) {
            this.connector().getFilterChain().addLast("logger", (IoFilter)new LoggingFilter());
        }
        this.connector().getFilterChain().addLast("codec", (IoFilter)MemcacheClientDecoder$.MODULE$.filter());
        this.connector().setHandler((IoHandler)new IoHandlerActorAdapter((Function1)new $anonfun$1(this)));
    }

    public String toString() {
        return new BoxedObjectArray((Object[])this.servers()).mkString(", ");
    }

    public void shutdown() {
        new BoxedObjectArray((Object[])this.servers()).foreach((Function1)new $anonfun$shutdown$1(this));
        Object object = ScalaRunTime$.MODULE$.arrayValue(Array$.MODULE$.apply((Seq)new BoxedObjectArray((Object[])new MemcacheConnection[0])), MemcacheConnection.class);
        this.servers_$eq((MemcacheConnection[])(object instanceof BoxedArray ? ScalaRunTime$.MODULE$.arrayValue((BoxedArray)object, MemcacheConnection.class) : object));
        this.connector().dispose();
        this.threadPool().shutdown();
    }

    public void scanForEjections() {
        ServerPool serverPool = this;
        synchronized (serverPool) {
            this.watchList().clear();
            this.watchList().$plus$plus$eq((Iterable)new BoxedObjectArray((Object[])this.servers()).filter((Function1)new $anonfun$scanForEjections$1(this)));
            return;
        }
    }

    public boolean shouldRecheckEjectedConnections() {
        ServerPool serverPool = this;
        synchronized (serverPool) {
            Boolean bl;
            if (this.watchList().exists((Function1)new $anonfun$shouldRecheckEjectedConnections$1(this))) {
                this.scanForEjections();
                bl = BoxesRunTime.boxToBoolean((boolean)true);
            } else {
                bl = BoxesRunTime.boxToBoolean((boolean)false);
            }
            return BoxesRunTime.unboxToBoolean((Object)bl);
        }
    }

    public MemcacheConnection[] liveServers() {
        Object object = ScalaRunTime$.MODULE$.arrayValue(new BoxedObjectArray((Object[])this.servers()).filter((Function1)new $anonfun$liveServers$1(this)), MemcacheConnection.class);
        return (MemcacheConnection[])(object instanceof BoxedArray ? ScalaRunTime$.MODULE$.arrayValue((BoxedArray)object, MemcacheConnection.class) : object);
    }

    public void connector_$eq(NioSocketConnector x$1) {
        this.connector = x$1;
    }

    public NioSocketConnector connector() {
        return this.connector;
    }

    public void maxFailuresBeforeEjection_$eq(int x$1) {
        this.maxFailuresBeforeEjection = x$1;
    }

    public int maxFailuresBeforeEjection() {
        return this.maxFailuresBeforeEjection;
    }

    public void connectTimeout_$eq(int x$1) {
        this.connectTimeout = x$1;
    }

    public int connectTimeout() {
        return this.connectTimeout;
    }

    public void readTimeout_$eq(int x$1) {
        this.readTimeout = x$1;
    }

    public int readTimeout() {
        return this.readTimeout;
    }

    public void retryDelay_$eq(int x$1) {
        this.retryDelay = x$1;
    }

    public int retryDelay() {
        return this.retryDelay;
    }

    private void DEFAULT_CONNECT_TIMEOUT_$eq(int x$1) {
        this.DEFAULT_CONNECT_TIMEOUT = x$1;
    }

    private int DEFAULT_CONNECT_TIMEOUT() {
        return this.DEFAULT_CONNECT_TIMEOUT;
    }

    private ListBuffer<MemcacheConnection> watchList() {
        return this.watchList;
    }

    public void servers_$eq(MemcacheConnection[] x$1) {
        this.servers = x$1;
    }

    public MemcacheConnection[] servers() {
        return this.servers;
    }

    public void threadPool_$eq(ExecutorService x$1) {
        this.threadPool = x$1;
    }

    public ExecutorService threadPool() {
        return this.threadPool;
    }

    public ServerPool() {
        this(false);
    }

    public int $tag() throws RemoteException {
        return ScalaObject.class.$tag((ScalaObject)this);
    }
}

