/*
 * Decompiled with CFR 0.152.
 */
package net.lag.smile.kestrel;

import java.rmi.RemoteException;
import net.lag.configgy.ConfigMap;
import net.lag.logging.Logger;
import net.lag.logging.Logger$;
import net.lag.smile.kestrel.KestrelClient$;
import net.lag.smile.kestrel.MemcacheStore;
import net.lag.smile.kestrel.MemoryStore;
import net.lag.smile.kestrel.MessageStore;
import scala.Function1;
import scala.Math$;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.ScalaObject;
import scala.Seq;
import scala.runtime.BoxedObjectArray;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KestrelClient
implements ScalaObject {
    private MessageStore impl;
    private volatile boolean stopFlag;
    private final Logger log;
    private final MessageStore messageStore;

    public KestrelClient(MessageStore messageStore) {
        this.messageStore = messageStore;
        this.log = Logger$.MODULE$.get();
        this.stopFlag = false;
        this.impl = messageStore;
    }

    public void resume() {
        this.stopFlag_$eq(false);
    }

    public void pause() {
        this.stopFlag_$eq(true);
    }

    public void reset(MessageStore impl) {
        this.stopFlag_$eq(false);
        this.impl_$eq(impl);
    }

    public void shutdown() {
        this.stopFlag_$eq(true);
        this.impl().shutdown();
    }

    public <T> Object queueIterator(String key$1, Function1<String, T> unpacker$1) {
        return new $anon$1(this, key$1, unpacker$1);
    }

    public void put(String key, String value, int expiry) {
        try {
            this.impl().put(key, value, expiry);
        }
        catch (Exception exception) {
            this.log().warning("Exception talking to kestrel (set): %s -- retrying", (Seq)new BoxedObjectArray(new Object[]{exception}));
            Thread.sleep(250L);
            this.impl().put(key, value, expiry);
        }
    }

    public void put(String key, String value) {
        try {
            this.impl().put(key, value);
        }
        catch (Exception exception) {
            this.log().warning("Exception talking to kestrel (set): %s -- retrying", (Seq)new BoxedObjectArray(new Object[]{exception}));
            Thread.sleep(250L);
            this.impl().put(key, value);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <T> Option<T> getExpire(String key, long expire, Function1<String, Option<T>> pollMethod) {
        None$ rv = None$.MODULE$;
        int round = 0;
        long sleepMs = 10L;
        long SLEEPMAXMS = 250L;
        long SLEEPMINMS = 1L;
        double SLEEPMULTIPLICAND = 1.5;
        while (true) {
            None$ none$ = rv;
            None$ none$2 = None$.MODULE$;
            if (none$ == null) {
                if (none$2 != null) {
                    return rv;
                }
            } else if (!none$.equals(none$2)) return rv;
            if (this.stopFlag()) return rv;
            try {
                None$ none$3 = rv = (Option)pollMethod.apply((Object)key);
                None$ none$4 = None$.MODULE$;
                if (none$3 != null ? !none$3.equals(none$4) : none$4 != null) continue;
                long left = expire - System.currentTimeMillis();
                if (left < 0L) {
                    return None$.MODULE$;
                }
                if (round == 0) {
                    this.log().trace("waiting on kestrel queue: %s", (Seq)new BoxedObjectArray(new Object[]{key}));
                }
                ++round;
                sleepMs = Predef$.MODULE$.longWrapper(Predef$.MODULE$.longWrapper(Predef$.MODULE$.longWrapper(SLEEPMAXMS).min((long)((double)sleepMs * SLEEPMULTIPLICAND))).min(left)).max(SLEEPMINMS);
                Thread.sleep(sleepMs);
            }
            catch (InterruptedException interruptedException) {
                this.log().debug("Interrupted while talking to kestrel (get): %s -- rethrow", (Seq)new BoxedObjectArray(new Object[]{interruptedException}));
                throw interruptedException;
            }
        }
    }

    public Option<byte[]> getData(String key, int timeoutMsec) {
        long expire = timeoutMsec > 0 ? System.currentTimeMillis() + (long)timeoutMsec : Math$.MODULE$.MAX_LONG();
        return this.getExpire(key, expire, new $anonfun$getData$1(this));
    }

    public Option<String> get(String key, int timeoutMsec) {
        long expire = timeoutMsec > 0 ? System.currentTimeMillis() + (long)timeoutMsec : Math$.MODULE$.MAX_LONG();
        return this.getExpire(key, expire, new $anonfun$get$1(this));
    }

    public Option<byte[]> getData(String key) {
        return this.getData(key, 0);
    }

    public Option<String> get(String key) {
        return this.get(key, 0);
    }

    public Option<byte[]> pollData(String key) {
        return this.impl().pollData(key);
    }

    public Option<String> poll(String key) {
        return this.impl().poll(key);
    }

    public KestrelClient(ConfigMap config) {
        this(config.getBool("mock", false) ? new MemoryStore() : new MemcacheStore(config));
    }

    public void impl_$eq(MessageStore x$1) {
        this.impl = x$1;
    }

    public MessageStore impl() {
        return this.impl;
    }

    public void stopFlag_$eq(boolean x$1) {
        this.stopFlag = x$1;
    }

    public boolean stopFlag() {
        return this.stopFlag;
    }

    public Logger log() {
        return this.log;
    }

    public MessageStore messageStore() {
        return this.messageStore;
    }

    public int $tag() throws RemoteException {
        return ScalaObject.class.$tag((ScalaObject)this);
    }
}

