/*
 * Decompiled with CFR 0.152.
 */
package net.lakis.apollo;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import net.lakis.apollo.App;
import net.lakis.apollo.IConsoleHandler;
import net.lakis.apollo.SystemHandler;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class AbstractApollo {
    private static final Logger log = LogManager.getLogger(AbstractApollo.class);
    private List<IConsoleHandler> consoleHandlers = new ArrayList<IConsoleHandler>();
    private long pid;

    public static <T> T getHandler(Class<T> clazz) {
        for (IConsoleHandler handler : App.getApollo().getConsoleHandlers()) {
            if (!clazz.isAssignableFrom(handler.getClass())) continue;
            return (T)handler;
        }
        return null;
    }

    public AbstractApollo() {
        this.consoleHandlers.add(new SystemHandler());
    }

    public void safeInit() {
        try {
            this.init();
        }
        catch (Exception e) {
            log.error("Exception: ", (Throwable)e);
            System.exit(3);
        }
    }

    public void safeOnStart() {
        try {
            this.onStart();
        }
        catch (Exception e) {
            log.error("Exception: ", (Throwable)e);
            System.exit(3);
        }
    }

    public void safeOnStop() {
        try {
            this.onStop();
        }
        catch (Exception e) {
            log.error("Exception: ", (Throwable)e);
            System.exit(3);
        }
    }

    public abstract void init() throws Exception;

    public abstract void onStart() throws Exception;

    public abstract void onStop() throws Exception;

    public List<IConsoleHandler> getConsoleHandlers() {
        return this.consoleHandlers;
    }

    public void addConsoleHandler(IConsoleHandler handler) {
        this.consoleHandlers.add(handler);
    }

    public void removeConsoleHandler(IConsoleHandler handler) {
        this.consoleHandlers.remove(handler);
    }

    public void onInit() {
        for (Field field : this.getClass().getDeclaredFields()) {
            if (!IConsoleHandler.class.isAssignableFrom(field.getType())) continue;
            field.setAccessible(true);
            try {
                this.consoleHandlers.add((IConsoleHandler)field.get(this));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        for (IConsoleHandler handler : this.consoleHandlers) {
            handler.onInit();
        }
    }

    public long getPid() {
        return this.pid;
    }

    public void setPid(long pid) {
        this.pid = pid;
    }
}

