/*
 * Decompiled with CFR 0.152.
 */
package net.lakis.apollo;

import java.io.FileWriter;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.reflect.Constructor;
import java.net.UnknownHostException;
import net.lakis.apollo.AbstractApollo;
import net.lakis.apollo.client.Client;
import net.lakis.apollo.config.SystemProperties;
import net.lakis.apollo.server.Server;
import org.apache.commons.lang.StringUtils;

public class App {
    private static AbstractApollo apollo;

    public static void main(String[] args) throws Exception {
        App app = new App();
        if (args.length == 0) {
            app.connect();
        } else if (args[0].equalsIgnoreCase("run")) {
            app.run();
        } else {
            app.request(args);
        }
    }

    private void request(String[] args) throws IOException {
        String str = String.join((CharSequence)" ", args);
        Client.standaloneRequest(str);
    }

    private void connect() throws UnknownHostException, IOException {
        Client client = new Client();
        client.connect();
        client.loop();
    }

    private void writePidToFile() {
        block15: {
            String jvmName = ManagementFactory.getRuntimeMXBean().getName();
            System.out.println(jvmName);
            int index = jvmName.indexOf(64);
            if (index < 1) {
                return;
            }
            try {
                long pid = Long.parseLong(jvmName.substring(0, index));
                apollo.setPid(pid);
                String path = SystemProperties.INSTANCE.getPidPath();
                if (!StringUtils.isNotBlank((String)path)) break block15;
                try (FileWriter fileWriter = new FileWriter(path, false);){
                    fileWriter.write(String.valueOf(pid));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void run() throws Exception {
        Class<?> clazz = Class.forName(SystemProperties.INSTANCE.getApolloClass());
        Constructor<?> ctor = clazz.getConstructor(new Class[0]);
        apollo = (AbstractApollo)ctor.newInstance(new Object[0]);
        this.writePidToFile();
        apollo.safeInit();
        apollo.onInit();
        apollo.safeOnStart();
        Server appInterfaceServer = new Server(apollo);
        appInterfaceServer.start();
    }

    public static AbstractApollo getApollo() {
        return apollo;
    }
}

