/*
 * Decompiled with CFR 0.152.
 */
package net.lakis.apollo;

import java.io.InputStream;
import java.util.Properties;
import net.lakis.apollo.App;
import net.lakis.apollo.IConsoleHandler;
import net.lakis.apollo.annotations.ConsoleKey;
import org.apache.commons.lang.StringUtils;

@ConsoleKey(value="system")
public class SystemHandler
implements IConsoleHandler {
    private Properties prop;

    @ConsoleKey(value="getHeapSize")
    public String getHeapSize() {
        long heapSize = Runtime.getRuntime().totalMemory();
        long heapMaxSize = Runtime.getRuntime().maxMemory();
        long heapFreeSize = Runtime.getRuntime().freeMemory();
        return "heapSize: " + heapSize + " Bytes\nheapMaxSize: " + heapMaxSize + " Bytes\nheapFreeSize: " + heapFreeSize + " Bytes";
    }

    @ConsoleKey(value="getThreadsCount")
    public String getThreadsCount() {
        return "threadsCount: " + Thread.activeCount();
    }

    @ConsoleKey(value="collectGarbage")
    public String collectGarbage() {
        System.gc();
        return "Garbage collector called";
    }

    @ConsoleKey(value="getBuildInfo")
    public String getBuildInfo() {
        StringBuilder sb = new StringBuilder();
        for (Object key : this.prop.keySet()) {
            if (!key.toString().startsWith("build")) continue;
            sb.append(StringUtils.rightPad((String)key.toString(), (int)29));
            sb.append(": ");
            sb.append(this.prop.get(key));
            sb.append(System.lineSeparator());
        }
        return sb.toString();
    }

    @ConsoleKey(value="getGitInfo")
    public String getGitInfo() {
        StringBuilder sb = new StringBuilder();
        for (Object key : this.prop.keySet()) {
            if (!key.toString().startsWith("git")) continue;
            sb.append(StringUtils.rightPad((String)key.toString(), (int)29));
            sb.append(": ");
            sb.append(this.prop.get(key));
            sb.append(System.lineSeparator());
        }
        return sb.toString();
    }

    @ConsoleKey(value="getPID")
    public String getPID() {
        return String.valueOf(App.getApollo().getPid());
    }

    @Override
    public void onInit() {
        this.prop = new Properties();
        try (InputStream in = SystemHandler.class.getResourceAsStream("/apollo.conf");){
            this.prop.load(in);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

